/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.keymanagement.service;

import com.google.common.collect.Streams;
import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.attribute.support.SimpleFunction;
import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.QueryFactory;
import de.adorsys.keymanagement.api.types.ResultCollection;
import de.adorsys.keymanagement.api.types.entity.KeyAlias;
import de.adorsys.keymanagement.api.types.entity.KeyEntry;
import de.adorsys.keymanagement.api.types.entity.metadata.KeyMetadata;
import de.adorsys.keymanagement.api.view.EntryView;
import de.adorsys.sts.keymanagement.config.KeyManagementRotationProperties;
import de.adorsys.sts.keymanagement.model.GeneratedStsEntry;
import de.adorsys.sts.keymanagement.model.KeyRotationResult;
import de.adorsys.sts.keymanagement.model.KeyState;
import de.adorsys.sts.keymanagement.model.KeyUsage;
import de.adorsys.sts.keymanagement.model.StsKeyEntry;
import de.adorsys.sts.keymanagement.model.StsKeyStore;
import de.adorsys.sts.keymanagement.service.KeyRotationService;
import de.adorsys.sts.keymanagement.service.KeyStoreGenerator;
import de.adorsys.sts.keymanagement.util.DateTimeUtils;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class KeyRotationServiceImpl
implements KeyRotationService {
    private final SimpleFunction<KeyEntry, StsKeyEntry> STS = it -> (StsKeyEntry)it.getMeta();
    private final Attribute<KeyEntry, KeyState> STATE = QueryFactory.attribute(it -> ((StsKeyEntry)this.STS.apply(it)).getState());
    private final Attribute<KeyEntry, Instant> NOT_BEFORE = QueryFactory.attribute(it -> ((StsKeyEntry)this.STS.apply(it)).getNotBefore().toInstant());
    private final Attribute<KeyEntry, Instant> NOT_AFTER = QueryFactory.attribute(it -> ((StsKeyEntry)this.STS.apply(it)).getNotAfter().toInstant());
    private final Attribute<KeyEntry, Instant> EXPIRE_AT = QueryFactory.attribute(it -> ((StsKeyEntry)this.STS.apply(it)).getExpireAt().toInstant());
    private final Attribute<KeyEntry, KeyUsage> USAGE = QueryFactory.attribute(it -> ((StsKeyEntry)this.STS.apply(it)).getKeyUsage());
    private final KeyStoreGenerator keyStoreGenerator;
    private final Clock clock;
    private final KeyManagementRotationProperties.KeyRotationProperties encryptionKeyPairRotationProperties;
    private final KeyManagementRotationProperties.KeyRotationProperties signatureKeyPairRotationProperties;
    private final KeyManagementRotationProperties.KeyRotationProperties secretKeyRotationProperties;

    public KeyRotationServiceImpl(KeyStoreGenerator keyStoreGenerator, Clock clock, KeyManagementRotationProperties rotationProperties) {
        this.keyStoreGenerator = keyStoreGenerator;
        this.clock = clock;
        this.encryptionKeyPairRotationProperties = rotationProperties.getEncKeyPairs();
        this.signatureKeyPairRotationProperties = rotationProperties.getSignKeyPairs();
        this.secretKeyRotationProperties = rotationProperties.getSecretKeys();
    }

    public KeyRotationResult rotate(StsKeyStore stsKeyStore) {
        ZonedDateTime now = this.now();
        EntryView view = stsKeyStore.getView();
        Map<KeyUsage, Integer> rotationEnabledForWithCount = this.rotationEnabledForWithCount();
        Set<KeyUsage> rotationEnabledFor = rotationEnabledForWithCount.keySet();
        List<String> createdFutureKeys = this.moveCreatedToValidAndReplenish(now, (EntryView<Query<KeyEntry>>)view, rotationEnabledFor);
        this.moveValidToLegacy(now.toInstant(), (EntryView<Query<KeyEntry>>)view, rotationEnabledFor);
        List<String> dropped = this.moveLegacyToExpiredAndDrop(now.toInstant(), (EntryView<Query<KeyEntry>>)view, rotationEnabledFor);
        List<String> generatedKeyAliases = this.generateMissingValid(rotationEnabledForWithCount, (EntryView<Query<KeyEntry>>)view);
        return KeyRotationResult.builder().generatedKeys(generatedKeyAliases).removedKeys(dropped).futureKeys(createdFutureKeys).build();
    }

    private List<String> moveCreatedToValidAndReplenish(ZonedDateTime now, EntryView<Query<KeyEntry>> view, Collection<KeyUsage> rotationEnabledForUsages) {
        ResultCollection createdToValid = view.retrieve((Object)QueryFactory.and((Query)QueryFactory.equal(this.STATE, (Object)KeyState.CREATED), (Query)QueryFactory.lessThan(this.NOT_BEFORE, (Comparable)now.toInstant()), (Query)QueryFactory.in(this.USAGE, rotationEnabledForUsages))).toCollection();
        view.update((Collection)createdToValid.stream().map(it -> it.aliasWithMeta(StsKeyEntry.class)).map(it -> it.toBuilder().metadata((KeyMetadata)this.toValid(now, (StsKeyEntry)it.getMetadata())).build()).collect(Collectors.toList()));
        ArrayList<GeneratedStsEntry> createdKeys = new ArrayList<GeneratedStsEntry>();
        for (KeyEntry keyEntry : createdToValid) {
            StsKeyEntry original = (StsKeyEntry)keyEntry.getMeta();
            GeneratedStsEntry generatedKeyEntry = this.keyStoreGenerator.generateKeyEntryForFutureUsage(original.getKeyUsage(), original.getNotAfter());
            createdKeys.add(generatedKeyEntry);
        }
        view.add((Collection)createdKeys.stream().map(it -> it.getKey()).collect(Collectors.toList()));
        return createdKeys.stream().map(it -> it.getEntry().getAlias()).collect(Collectors.toList());
    }

    private void moveValidToLegacy(Instant now, EntryView<Query<KeyEntry>> view, Collection<KeyUsage> rotationEnabledForUsages) {
        ResultCollection expiredValid = view.retrieve((Object)QueryFactory.and((Query)QueryFactory.equal(this.STATE, (Object)KeyState.VALID), (Query)QueryFactory.lessThan(this.NOT_AFTER, (Comparable)now), (Query)QueryFactory.in(this.USAGE, rotationEnabledForUsages))).toCollection();
        view.update((Collection)expiredValid.stream().map(it -> it.aliasWithMeta(StsKeyEntry.class)).map(it -> it.toBuilder().metadata((KeyMetadata)this.toLegacy((StsKeyEntry)it.getMetadata())).build()).collect(Collectors.toList()));
    }

    private List<String> moveLegacyToExpiredAndDrop(Instant now, EntryView<Query<KeyEntry>> view, Collection<KeyUsage> rotationEnabledForUsages) {
        ResultCollection legacyExpiredEntries = view.retrieve((Object)QueryFactory.and((Query)QueryFactory.equal(this.STATE, (Object)KeyState.LEGACY), (Query)QueryFactory.lessThan(this.EXPIRE_AT, (Comparable)now), (Query)QueryFactory.in(this.USAGE, rotationEnabledForUsages))).toCollection();
        view.remove((Collection)legacyExpiredEntries);
        ResultCollection expired = view.retrieve((Object)QueryFactory.and((Query)QueryFactory.equal(this.STATE, (Object)KeyState.EXPIRED), (Query)QueryFactory.in(this.USAGE, rotationEnabledForUsages))).toCollection();
        view.remove((Collection)expired);
        return Streams.concat((Stream[])new Stream[]{legacyExpiredEntries.stream(), expired.stream()}).map(KeyAlias::getAlias).collect(Collectors.toList());
    }

    private List<String> generateMissingValid(Map<KeyUsage, Integer> rotationEnabledForWithCount, EntryView<Query<KeyEntry>> view) {
        ArrayList<GeneratedStsEntry> generatedMissing = new ArrayList<GeneratedStsEntry>();
        for (Map.Entry<KeyUsage, Integer> toCheck : rotationEnabledForWithCount.entrySet()) {
            int countValidForUsage = view.retrieve((Object)QueryFactory.and((Query)QueryFactory.equal(this.STATE, (Object)KeyState.VALID), (Query)QueryFactory.equal(this.USAGE, (Object)toCheck.getKey()))).toCollection().size();
            for (int i = 0; i < toCheck.getValue() - countValidForUsage; ++i) {
                generatedMissing.add(this.generateKey(toCheck.getKey()));
            }
        }
        view.add((Collection)generatedMissing.stream().map(it -> it.getKey()).collect(Collectors.toList()));
        return generatedMissing.stream().map(it -> it.getEntry().getAlias()).collect(Collectors.toList());
    }

    private Map<KeyUsage, Integer> rotationEnabledForWithCount() {
        HashMap<KeyUsage, Integer> result = new HashMap<KeyUsage, Integer>();
        if (this.encryptionKeyPairRotationProperties.isEnabled().booleanValue()) {
            result.put(KeyUsage.Encryption, this.encryptionKeyPairRotationProperties.getMinKeys());
        }
        if (this.signatureKeyPairRotationProperties.isEnabled().booleanValue()) {
            result.put(KeyUsage.Signature, this.signatureKeyPairRotationProperties.getMinKeys());
        }
        if (this.secretKeyRotationProperties.isEnabled().booleanValue()) {
            result.put(KeyUsage.SecretKey, this.secretKeyRotationProperties.getMinKeys());
        }
        return result;
    }

    private StsKeyEntry toLegacy(StsKeyEntry entry) {
        entry.setState(KeyState.LEGACY);
        return entry;
    }

    private StsKeyEntry toValid(ZonedDateTime now, StsKeyEntry entry) {
        entry.setNotAfter(DateTimeUtils.addMillis(now, entry.getValidityInterval()));
        entry.setExpireAt(DateTimeUtils.addMillis(now, entry.getLegacyInterval()));
        entry.setState(KeyState.VALID);
        return entry;
    }

    private GeneratedStsEntry generateKey(KeyUsage keyUsage) {
        if (keyUsage == KeyUsage.Signature) {
            return this.keyStoreGenerator.generateSignatureKeyEntryForInstantUsage();
        }
        if (keyUsage == KeyUsage.Encryption) {
            return this.keyStoreGenerator.generateEncryptionKeyEntryForInstantUsage();
        }
        if (keyUsage == KeyUsage.SecretKey) {
            return this.keyStoreGenerator.generateSecretKeyEntryForInstantUsage();
        }
        throw new IllegalArgumentException("Unknown KeyUsage: " + String.valueOf(keyUsage));
    }

    private ZonedDateTime now() {
        return this.clock.instant().atZone(ZoneOffset.UTC);
    }
}

