/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.keymanagement.service;

import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import de.adorsys.keymanagement.api.types.ResultCollection;
import de.adorsys.keymanagement.api.types.entity.KeyEntry;
import de.adorsys.sts.keymanagement.model.ServerKeysHolder;
import de.adorsys.sts.keymanagement.model.StsKeyStore;
import de.adorsys.sts.keymanagement.model.UnmodifyableKeyStoreViewer;
import de.adorsys.sts.keymanagement.service.KeyConversionService;
import java.security.KeyStore;
import java.util.ArrayList;

public class KeyConversionServiceImpl
implements KeyConversionService {
    private final String keyStorePassword;

    public ServerKeysHolder export(StsKeyStore keyStore) {
        KeyStore toParse = new UnmodifyableKeyStoreViewer(keyStore.getKeyStoreCopy()).getKeyStore();
        ResultCollection keyEntries = keyStore.getView().all();
        ArrayList<JWK> keys = new ArrayList<JWK>();
        for (KeyEntry entry : keyEntries) {
            keys.add(JWK.load((KeyStore)toParse, (String)entry.getAlias(), (char[])this.keyStorePassword.toCharArray()));
        }
        JWKSet privateKeys = new JWKSet(keys);
        JWKSet publicKeys = privateKeys.toPublicJWKSet();
        return new ServerKeysHolder(privateKeys, publicKeys);
    }

    public KeyConversionServiceImpl(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }
}

