/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.keymanagement.service;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.crypto.factories.DefaultJWEDecrypterFactory;
import de.adorsys.sts.keymanagement.exceptions.SecretDecryptionException;
import de.adorsys.sts.keymanagement.service.DecryptionService;
import de.adorsys.sts.keymanagement.service.ServerKeyMapProvider;
import java.security.Key;
import java.text.ParseException;

public class DecryptionServiceImpl
implements DecryptionService {
    private final ServerKeyMapProvider keyMapProvider;
    private final DefaultJWEDecrypterFactory decrypterFactory = new DefaultJWEDecrypterFactory();

    public DecryptionServiceImpl(ServerKeyMapProvider keyMapProvider) {
        this.keyMapProvider = keyMapProvider;
    }

    public String decrypt(String encrypted) {
        JWEDecrypter decrypter;
        JWEObject jweObject;
        try {
            jweObject = JWEObject.parse((String)encrypted);
        }
        catch (ParseException e) {
            throw new SecretDecryptionException((Throwable)e);
        }
        String keyID = jweObject.getHeader().getKeyID();
        Key key = this.keyMapProvider.getKey(keyID);
        if (key == null) {
            throw new IllegalStateException("No suitable key found");
        }
        try {
            decrypter = this.decrypterFactory.createJWEDecrypter(jweObject.getHeader(), key);
        }
        catch (JOSEException e) {
            throw new SecretDecryptionException((Throwable)e);
        }
        try {
            jweObject.decrypt(decrypter);
        }
        catch (JOSEException e) {
            throw new SecretDecryptionException((Throwable)e);
        }
        return jweObject.getPayload().toString();
    }
}

