/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.keymanagement.model;

import de.adorsys.keymanagement.api.Juggler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;
import java.util.function.Supplier;

public class UnmodifyableKeystore {
    private final KeyStore delegate;

    public UnmodifyableKeystore(KeyStore delegate) {
        this.delegate = delegate;
    }

    public byte[] toBytes(Juggler juggler, Supplier<char[]> readKeyStorePassword) {
        return juggler.serializeDeserialize().serialize(this.delegate, readKeyStorePassword);
    }

    KeyStore getDelegate() {
        return this.delegate;
    }

    public Provider getProvider() {
        return this.getDelegate().getProvider();
    }

    public String getType() {
        return this.getDelegate().getType();
    }

    public Key getKey(String alias, char[] password) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        return this.getDelegate().getKey(alias, password);
    }

    public Certificate[] getCertificateChain(String alias) throws KeyStoreException {
        return this.getDelegate().getCertificateChain(alias);
    }

    public Certificate getCertificate(String alias) throws KeyStoreException {
        return this.getDelegate().getCertificate(alias);
    }

    public Date getCreationDate(String alias) throws KeyStoreException {
        return this.getDelegate().getCreationDate(alias);
    }

    public Enumeration<String> aliases() throws KeyStoreException {
        return this.getDelegate().aliases();
    }

    public boolean containsAlias(String alias) throws KeyStoreException {
        return this.getDelegate().containsAlias(alias);
    }

    public int size() throws KeyStoreException {
        return this.getDelegate().size();
    }

    public boolean isKeyEntry(String alias) throws KeyStoreException {
        return this.getDelegate().isKeyEntry(alias);
    }

    public boolean isCertificateEntry(String alias) throws KeyStoreException {
        return this.getDelegate().isCertificateEntry(alias);
    }

    public String getCertificateAlias(Certificate cert) throws KeyStoreException {
        return this.getDelegate().getCertificateAlias(cert);
    }

    public void store(OutputStream stream, char[] password) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        this.getDelegate().store(stream, password);
    }

    public void store(KeyStore.LoadStoreParameter param) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        this.getDelegate().store(param);
    }

    public KeyStore.Entry getEntry(String alias, KeyStore.ProtectionParameter protParam) throws NoSuchAlgorithmException, UnrecoverableEntryException, KeyStoreException {
        return this.getDelegate().getEntry(alias, protParam);
    }

    public boolean entryInstanceOf(String alias, Class<? extends KeyStore.Entry> entryClass) throws KeyStoreException {
        return this.getDelegate().entryInstanceOf(alias, entryClass);
    }

    private static interface ExcludeOperations {
        public void load(InputStream var1, char[] var2);

        public void load(KeyStore.LoadStoreParameter var1);

        public void deleteEntry(String var1);

        public void setEntry(String var1, KeyStore.Entry var2, KeyStore.ProtectionParameter var3);

        public void setCertificateEntry(String var1, Certificate var2);

        public void setKeyEntry(String var1, byte[] var2, Certificate[] var3);

        public void setKeyEntry(String var1, Key var2, char[] var3, Certificate[] var4);
    }
}

