/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.keymanagement.model;

import com.google.common.collect.ImmutableMap;
import de.adorsys.keymanagement.api.types.ResultCollection;
import de.adorsys.keymanagement.api.types.entity.KeyEntry;
import de.adorsys.keymanagement.api.view.EntryView;
import de.adorsys.sts.keymanagement.model.ImmutableStsKeyEntry;
import de.adorsys.sts.keymanagement.model.StsKeyEntry;
import de.adorsys.sts.keymanagement.model.UnmodifyableKeystore;
import java.security.KeyStore;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;

public class StsKeyStore {
    @NonNull
    private final KeyStore keyStore;
    @NonNull
    private final EntryView<?> view;
    private ZonedDateTime lastUpdate;

    public Map<String, StsKeyEntry> getEntries() {
        ResultCollection entries = this.view.all();
        HashMap<String, ImmutableStsKeyEntry> result = new HashMap<String, ImmutableStsKeyEntry>();
        for (KeyEntry entry : entries) {
            result.put(entry.getAlias(), new ImmutableStsKeyEntry((StsKeyEntry)entry.getMeta()));
        }
        return ImmutableMap.copyOf(result);
    }

    public UnmodifyableKeystore getKeyStoreCopy() {
        return new UnmodifyableKeystore(this.keyStore);
    }

    public void setLastUpdate(ZonedDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public static StsKeyStoreBuilder builder() {
        return new StsKeyStoreBuilder();
    }

    public StsKeyStore(@NonNull KeyStore keyStore, @NonNull EntryView<?> view, ZonedDateTime lastUpdate) {
        if (keyStore == null) {
            throw new NullPointerException("keyStore is marked @NonNull but is null");
        }
        if (view == null) {
            throw new NullPointerException("view is marked @NonNull but is null");
        }
        this.keyStore = keyStore;
        this.view = view;
        this.lastUpdate = lastUpdate;
    }

    @NonNull
    public EntryView<?> getView() {
        return this.view;
    }

    public ZonedDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    public static class StsKeyStoreBuilder {
        private KeyStore keyStore;
        private EntryView<?> view;
        private ZonedDateTime lastUpdate;

        StsKeyStoreBuilder() {
        }

        public StsKeyStoreBuilder keyStore(@NonNull KeyStore keyStore) {
            if (keyStore == null) {
                throw new NullPointerException("keyStore is marked @NonNull but is null");
            }
            this.keyStore = keyStore;
            return this;
        }

        public StsKeyStoreBuilder view(@NonNull EntryView<?> view) {
            if (view == null) {
                throw new NullPointerException("view is marked @NonNull but is null");
            }
            this.view = view;
            return this;
        }

        public StsKeyStoreBuilder lastUpdate(ZonedDateTime lastUpdate) {
            this.lastUpdate = lastUpdate;
            return this;
        }

        public StsKeyStore build() {
            return new StsKeyStore(this.keyStore, this.view, this.lastUpdate);
        }

        public String toString() {
            return "StsKeyStore.StsKeyStoreBuilder(keyStore=" + this.keyStore + ", view=" + this.view + ", lastUpdate=" + this.lastUpdate + ")";
        }
    }
}

