/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.persistence;

import de.adorsys.sts.keymanagement.model.KeyUsage;
import de.adorsys.sts.keymanagement.model.StsKeyEntry;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.time.ZonedDateTime;
import org.adorsys.encobject.userdata.ObjectMapperSPI;
import org.adorsys.jkeygen.keystore.KeyEntry;

public class KeyEntryMapper {
    private final ObjectMapperSPI objectMapper;

    public KeyEntryMapper(ObjectMapperSPI objectMapper) {
        this.objectMapper = objectMapper;
    }

    public String extractEntryAttributesToString(StsKeyEntry keyEntry) {
        String valuesAsString;
        try {
            KeyEntryAttributes attributes = KeyEntryAttributes.builder().createdAt(keyEntry.getCreatedAt()).notBefore(keyEntry.getNotBefore()).notAfter(keyEntry.getNotAfter()).expireAt(keyEntry.getExpireAt()).validityInterval(keyEntry.getValidityInterval()).legacyInterval(keyEntry.getLegacyInterval()).state(keyEntry.getState()).keyUsage(keyEntry.getKeyUsage()).build();
            valuesAsString = this.objectMapper.writeValueAsString((Object)attributes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return valuesAsString;
    }

    public StsKeyEntry mapFromKeyEntryWithAttributes(KeyEntry keyEntry, String attributesAsString) {
        KeyEntryAttributes attributes;
        try {
            attributes = (KeyEntryAttributes)this.objectMapper.readValue(attributesAsString, KeyEntryAttributes.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return StsKeyEntry.builder().alias(keyEntry.getAlias()).createdAt(attributes.getCreatedAt()).notBefore(attributes.getNotBefore()).notAfter(attributes.getNotAfter()).expireAt(attributes.getExpireAt()).validityInterval(attributes.getValidityInterval()).legacyInterval(attributes.getValidityInterval()).state(attributes.getState()).keyUsage(attributes.getKeyUsage()).keyEntry(keyEntry).build();
    }

    private static class KeyEntryAttributes {
        private ZonedDateTime createdAt;
        private ZonedDateTime notBefore;
        private ZonedDateTime notAfter;
        private ZonedDateTime expireAt;
        private Long validityInterval;
        private Long legacyInterval;
        private StsKeyEntry.State state;
        private KeyUsage keyUsage;

        @ConstructorProperties(value={"createdAt", "notBefore", "notAfter", "expireAt", "validityInterval", "legacyInterval", "state", "keyUsage"})
        KeyEntryAttributes(ZonedDateTime createdAt, ZonedDateTime notBefore, ZonedDateTime notAfter, ZonedDateTime expireAt, Long validityInterval, Long legacyInterval, StsKeyEntry.State state, KeyUsage keyUsage) {
            this.createdAt = createdAt;
            this.notBefore = notBefore;
            this.notAfter = notAfter;
            this.expireAt = expireAt;
            this.validityInterval = validityInterval;
            this.legacyInterval = legacyInterval;
            this.state = state;
            this.keyUsage = keyUsage;
        }

        public static KeyEntryAttributesBuilder builder() {
            return new KeyEntryAttributesBuilder();
        }

        public ZonedDateTime getCreatedAt() {
            return this.createdAt;
        }

        public ZonedDateTime getNotBefore() {
            return this.notBefore;
        }

        public ZonedDateTime getNotAfter() {
            return this.notAfter;
        }

        public ZonedDateTime getExpireAt() {
            return this.expireAt;
        }

        public Long getValidityInterval() {
            return this.validityInterval;
        }

        public Long getLegacyInterval() {
            return this.legacyInterval;
        }

        public StsKeyEntry.State getState() {
            return this.state;
        }

        public KeyUsage getKeyUsage() {
            return this.keyUsage;
        }

        public void setCreatedAt(ZonedDateTime createdAt) {
            this.createdAt = createdAt;
        }

        public void setNotBefore(ZonedDateTime notBefore) {
            this.notBefore = notBefore;
        }

        public void setNotAfter(ZonedDateTime notAfter) {
            this.notAfter = notAfter;
        }

        public void setExpireAt(ZonedDateTime expireAt) {
            this.expireAt = expireAt;
        }

        public void setValidityInterval(Long validityInterval) {
            this.validityInterval = validityInterval;
        }

        public void setLegacyInterval(Long legacyInterval) {
            this.legacyInterval = legacyInterval;
        }

        public void setState(StsKeyEntry.State state) {
            this.state = state;
        }

        public void setKeyUsage(KeyUsage keyUsage) {
            this.keyUsage = keyUsage;
        }

        public static class KeyEntryAttributesBuilder {
            private ZonedDateTime createdAt;
            private ZonedDateTime notBefore;
            private ZonedDateTime notAfter;
            private ZonedDateTime expireAt;
            private Long validityInterval;
            private Long legacyInterval;
            private StsKeyEntry.State state;
            private KeyUsage keyUsage;

            KeyEntryAttributesBuilder() {
            }

            public KeyEntryAttributesBuilder createdAt(ZonedDateTime createdAt) {
                this.createdAt = createdAt;
                return this;
            }

            public KeyEntryAttributesBuilder notBefore(ZonedDateTime notBefore) {
                this.notBefore = notBefore;
                return this;
            }

            public KeyEntryAttributesBuilder notAfter(ZonedDateTime notAfter) {
                this.notAfter = notAfter;
                return this;
            }

            public KeyEntryAttributesBuilder expireAt(ZonedDateTime expireAt) {
                this.expireAt = expireAt;
                return this;
            }

            public KeyEntryAttributesBuilder validityInterval(Long validityInterval) {
                this.validityInterval = validityInterval;
                return this;
            }

            public KeyEntryAttributesBuilder legacyInterval(Long legacyInterval) {
                this.legacyInterval = legacyInterval;
                return this;
            }

            public KeyEntryAttributesBuilder state(StsKeyEntry.State state) {
                this.state = state;
                return this;
            }

            public KeyEntryAttributesBuilder keyUsage(KeyUsage keyUsage) {
                this.keyUsage = keyUsage;
                return this;
            }

            public KeyEntryAttributes build() {
                return new KeyEntryAttributes(this.createdAt, this.notBefore, this.notAfter, this.expireAt, this.validityInterval, this.legacyInterval, this.state, this.keyUsage);
            }

            public String toString() {
                return "KeyEntryMapper.KeyEntryAttributes.KeyEntryAttributesBuilder(createdAt=" + this.createdAt + ", notBefore=" + this.notBefore + ", notAfter=" + this.notAfter + ", expireAt=" + this.expireAt + ", validityInterval=" + this.validityInterval + ", legacyInterval=" + this.legacyInterval + ", state=" + this.state + ", keyUsage=" + this.keyUsage + ")";
            }
        }
    }
}

