/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.persistence;

import de.adorsys.sts.keymanagement.model.StsKeyEntry;
import de.adorsys.sts.keymanagement.model.StsKeyStore;
import de.adorsys.sts.keymanagement.persistence.KeyStoreRepository;
import de.adorsys.sts.keymanagement.service.KeyManagementProperties;
import de.adorsys.sts.persistence.KeyEntryMapper;
import java.io.IOException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.security.auth.callback.CallbackHandler;
import org.adorsys.encobject.domain.ObjectHandle;
import org.adorsys.encobject.domain.Tuple;
import org.adorsys.encobject.filesystem.FsPersistenceFactory;
import org.adorsys.encobject.service.ContainerExistsException;
import org.adorsys.encobject.service.ContainerPersistence;
import org.adorsys.encobject.service.KeystoreNotFoundException;
import org.adorsys.encobject.service.MissingKeyAlgorithmException;
import org.adorsys.encobject.service.MissingKeystoreAlgorithmException;
import org.adorsys.encobject.service.MissingKeystoreProviderException;
import org.adorsys.encobject.service.UnknownContainerException;
import org.adorsys.encobject.service.WrongKeystoreCredentialException;
import org.adorsys.jkeygen.keystore.KeyEntry;
import org.adorsys.jkeygen.keystore.KeyStoreService;
import org.adorsys.jkeygen.pwd.PasswordCallbackHandler;

public class FsPersistenceKeyStoreRepository
implements KeyStoreRepository {
    private final FsPersistenceFactory persFactory;
    private final String keystoreContainerName;
    private final String keystoreName;
    private final CallbackHandler keyPassHandler;
    private final KeyEntryMapper keyEntryMapper;

    public FsPersistenceKeyStoreRepository(FsPersistenceFactory persFactory, KeyManagementProperties keyManagementProperties, KeyEntryMapper keyEntryMapper) {
        this.persFactory = persFactory;
        this.keystoreContainerName = keyManagementProperties.getPersistence().getContainerName();
        this.keystoreName = keyManagementProperties.getKeystore().getName();
        this.keyEntryMapper = keyEntryMapper;
        String keyStorePassword = keyManagementProperties.getKeystore().getPassword();
        this.keyPassHandler = new PasswordCallbackHandler(keyStorePassword.toCharArray());
    }

    @PostConstruct
    public void postConstruct() {
        ContainerPersistence containerPersistence = this.persFactory.getContainerPersistence();
        if (!containerPersistence.containerExists(this.keystoreContainerName)) {
            try {
                containerPersistence.creteContainer(this.keystoreContainerName);
            }
            catch (ContainerExistsException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public StsKeyStore load() {
        ObjectHandle handle = new ObjectHandle(this.keystoreContainerName, this.keystoreName);
        try {
            Tuple keyStoreAndAttributes = this.persFactory.getKeystorePersistence().loadKeystoreAndAttributes(handle, this.keyPassHandler);
            KeyStore keyStore = (KeyStore)keyStoreAndAttributes.getX();
            Map attributesMap = (Map)keyStoreAndAttributes.getY();
            Map<String, StsKeyEntry> loadedKeyEntries = this.loadKeyEntries(keyStore, attributesMap);
            return StsKeyStore.builder().keyStore(keyStore).keyEntries(loadedKeyEntries).build();
        }
        catch (IOException | CertificateException | KeystoreNotFoundException | MissingKeyAlgorithmException | MissingKeystoreAlgorithmException | MissingKeystoreProviderException | UnknownContainerException | WrongKeystoreCredentialException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, StsKeyEntry> loadKeyEntries(KeyStore keyStore, Map<String, String> attributesMap) {
        HashMap<String, StsKeyEntry> loadedKeyEntries = new HashMap<String, StsKeyEntry>();
        List keyEntries = KeyStoreService.loadEntries((KeyStore)keyStore, (KeyStoreService.PasswordProvider)new KeyStoreService.SimplePasswordProvider(this.keyPassHandler));
        for (KeyEntry keyEntry : keyEntries) {
            String alias = keyEntry.getAlias();
            String attributes = attributesMap.get(alias);
            StsKeyEntry stsKeyEntry = this.keyEntryMapper.mapFromKeyEntryWithAttributes(keyEntry, attributes);
            loadedKeyEntries.put(alias, stsKeyEntry);
        }
        return loadedKeyEntries;
    }

    public boolean exists() {
        ObjectHandle handle = new ObjectHandle(this.keystoreContainerName, this.keystoreName);
        return this.persFactory.getKeystorePersistence().hasKeystore(handle);
    }

    public void save(StsKeyStore keyStore) {
        ObjectHandle handle = new ObjectHandle(this.keystoreContainerName, this.keystoreName);
        try {
            Map<String, String> attributes = this.buildAttributes(keyStore);
            this.persFactory.getKeystorePersistence().saveKeyStoreWithAttributes(keyStore.getKeyStore(), attributes, this.keyPassHandler, handle);
        }
        catch (NoSuchAlgorithmException | CertificateException | UnknownContainerException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, String> buildAttributes(StsKeyStore keyStore) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (Map.Entry entry : keyStore.getKeyEntries().entrySet()) {
            String alias = (String)entry.getKey();
            StsKeyEntry keyEntry = (StsKeyEntry)entry.getValue();
            String valuesAsString = this.keyEntryMapper.extractEntryAttributesToString(keyEntry);
            attributes.put(alias, valuesAsString);
        }
        return attributes;
    }
}

