/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.persistence;

import de.adorsys.sts.keymanagement.model.StsKeyStore;
import de.adorsys.sts.keymanagement.persistence.KeyStoreRepository;
import de.adorsys.sts.keymanagement.service.KeyManagementProperties;
import java.io.IOException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.annotation.PostConstruct;
import javax.security.auth.callback.CallbackHandler;
import org.adorsys.encobject.domain.ObjectHandle;
import org.adorsys.encobject.filesystem.FsPersistenceFactory;
import org.adorsys.encobject.service.ContainerExistsException;
import org.adorsys.encobject.service.ContainerPersistence;
import org.adorsys.encobject.service.KeystoreNotFoundException;
import org.adorsys.encobject.service.MissingKeyAlgorithmException;
import org.adorsys.encobject.service.MissingKeystoreAlgorithmException;
import org.adorsys.encobject.service.MissingKeystoreProviderException;
import org.adorsys.encobject.service.UnknownContainerException;
import org.adorsys.encobject.service.WrongKeystoreCredentialException;
import org.adorsys.jkeygen.pwd.PasswordCallbackHandler;

public class FsPersistenceKeyStoreRepository
implements KeyStoreRepository {
    private final FsPersistenceFactory persFactory;
    private final String keystoreContainerName;
    private final String keystoreName;
    private final CallbackHandler keyPassHandler;

    public FsPersistenceKeyStoreRepository(FsPersistenceFactory persFactory, String keystoreContainerName, String keystoreName, String keyStorePassword) {
        this.persFactory = persFactory;
        this.keystoreContainerName = keystoreContainerName;
        this.keystoreName = keystoreName;
        this.keyPassHandler = new PasswordCallbackHandler(keyStorePassword.toCharArray());
    }

    public FsPersistenceKeyStoreRepository(FsPersistenceFactory persFactory, KeyManagementProperties keyManagementProperties) {
        this.persFactory = persFactory;
        this.keystoreContainerName = keyManagementProperties.getPersistence().getContainerName();
        this.keystoreName = keyManagementProperties.getKeystore().getName();
        String keyStorePassword = keyManagementProperties.getPersistence().getPassword();
        this.keyPassHandler = new PasswordCallbackHandler(keyStorePassword.toCharArray());
    }

    @PostConstruct
    public void postConstruct() {
        ContainerPersistence containerPersistence = this.persFactory.getContainerPersistence();
        if (!containerPersistence.containerExists(this.keystoreContainerName)) {
            try {
                containerPersistence.creteContainer(this.keystoreContainerName);
            }
            catch (ContainerExistsException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public StsKeyStore load() {
        ObjectHandle handle = new ObjectHandle(this.keystoreContainerName, this.keystoreName);
        try {
            KeyStore keyStore = this.persFactory.getKeystorePersistence().loadKeystore(handle, this.keyPassHandler);
            return StsKeyStore.builder().keyStore(keyStore).keyEntries(null).build();
        }
        catch (IOException | CertificateException | KeystoreNotFoundException | MissingKeyAlgorithmException | MissingKeystoreAlgorithmException | MissingKeystoreProviderException | UnknownContainerException | WrongKeystoreCredentialException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean exists() {
        ObjectHandle handle = new ObjectHandle(this.keystoreContainerName, this.keystoreName);
        return this.persFactory.getKeystorePersistence().hasKeystore(handle);
    }

    public void save(StsKeyStore keyStore) {
        ObjectHandle handle = new ObjectHandle(this.keystoreContainerName, this.keystoreName);
        try {
            this.persFactory.getKeystorePersistence().saveKeyStore(keyStore.getKeyStore(), this.keyPassHandler, handle);
        }
        catch (NoSuchAlgorithmException | CertificateException | UnknownContainerException e) {
            throw new RuntimeException(e);
        }
    }
}

