/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.example.config;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import de.adorsys.sts.persistence.mongo.config.EnableMongoPersistence;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.data.mongodb.config.AbstractMongoConfiguration;

@Configuration
@EnableMongoPersistence
@Profile(value={"mongo"})
public class MongoConfiguration
extends AbstractMongoConfiguration {
    @Value(value="${spring.data.mongodb.database:sts}")
    private String databaseName;
    @Value(value="${spring.data.mongodb.uri:mongodb://localhost/sts}")
    private String uri;

    protected String getDatabaseName() {
        return this.databaseName;
    }

    public MongoClient mongoClient() {
        return new MongoClient(new MongoClientURI(this.uri));
    }
}

