/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.cryptoutils;

import de.adorsys.sts.cryptoutils.CertificationResult;
import de.adorsys.sts.cryptoutils.KeyEntryData;
import de.adorsys.sts.cryptoutils.KeyPairEntry;
import de.adorsys.sts.cryptoutils.SelfSignedKeyPairData;
import javax.security.auth.callback.CallbackHandler;

public class KeyPairData
extends KeyEntryData
implements KeyPairEntry {
    private final SelfSignedKeyPairData keyPair;
    private final CertificationResult certification;

    private KeyPairData(CallbackHandler passwordSource, String alias, SelfSignedKeyPairData keyPair, CertificationResult certification) {
        super(passwordSource, alias);
        this.keyPair = keyPair;
        this.certification = certification;
    }

    public static KeyPairDataBuilder builder() {
        return new KeyPairDataBuilder();
    }

    @Override
    public SelfSignedKeyPairData getKeyPair() {
        return this.keyPair;
    }

    @Override
    public CertificationResult getCertification() {
        return this.certification;
    }

    public static class KeyPairDataBuilder {
        private CallbackHandler passwordSource;
        private String alias;
        private SelfSignedKeyPairData keyPair;
        private CertificationResult certification;

        KeyPairDataBuilder() {
        }

        public KeyPairDataBuilder passwordSource(CallbackHandler passwordSource) {
            this.passwordSource = passwordSource;
            return this;
        }

        public KeyPairDataBuilder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public KeyPairDataBuilder keyPair(SelfSignedKeyPairData keyPair) {
            this.keyPair = keyPair;
            return this;
        }

        public KeyPairDataBuilder certification(CertificationResult certification) {
            this.certification = certification;
            return this;
        }

        public KeyPairData build() {
            return new KeyPairData(this.passwordSource, this.alias, this.keyPair, this.certification);
        }

        public String toString() {
            return "KeyPairData.KeyPairDataBuilder(passwordSource=" + this.passwordSource + ", alias=" + this.alias + ", keyPair=" + this.keyPair + ", certification=" + this.certification + ")";
        }
    }
}

