/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.cryptoutils;

import de.adorsys.sts.cryptoutils.CertificationResult;
import de.adorsys.sts.cryptoutils.KeyEntry;
import de.adorsys.sts.cryptoutils.KeyPairData;
import de.adorsys.sts.cryptoutils.KeyPairEntry;
import de.adorsys.sts.cryptoutils.KeyStoreType;
import de.adorsys.sts.cryptoutils.PasswordCallbackHandler;
import de.adorsys.sts.cryptoutils.PasswordCallbackUtils;
import de.adorsys.sts.cryptoutils.SecretKeyData;
import de.adorsys.sts.cryptoutils.SecretKeyEntry;
import de.adorsys.sts.cryptoutils.SelfSignedKeyPairData;
import de.adorsys.sts.cryptoutils.TrustedCertData;
import de.adorsys.sts.cryptoutils.TrustedCertEntry;
import de.adorsys.sts.cryptoutils.V3CertificateUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.crypto.SecretKey;
import javax.security.auth.callback.CallbackHandler;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.cert.X509CertificateHolder;

public class KeyStoreService {
    private KeyStoreService() {
        throw new IllegalStateException("Not supported");
    }

    public static KeyStore newKeyStore(KeyStoreType keyStoreType) {
        try {
            if (keyStoreType == null) {
                keyStoreType = KeyStoreType.DEFAULT;
            }
            KeyStore ks = KeyStore.getInstance(keyStoreType.getValue());
            ks.load(null, null);
            return ks;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] toByteArray(KeyStore keystore, String storeId, CallbackHandler storePassSrc) {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            keystore.store(stream, PasswordCallbackUtils.getPassword(storePassSrc, storeId));
            return stream.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static KeyStore loadKeyStore(InputStream in, String storeId, KeyStoreType storeType, CallbackHandler storePassSrc) {
        try {
            if (storeType == null) {
                storeType = KeyStoreType.DEFAULT;
            }
            KeyStore ks = KeyStore.getInstance(storeType.getValue());
            ks.load(in, PasswordCallbackUtils.getPassword(storePassSrc, storeId));
            return ks;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static KeyStore loadKeyStore(KeyStoreType keyStoreType, KeyStore.LoadStoreParameter loadStoreParameter) {
        try {
            if (keyStoreType == null) {
                keyStoreType = KeyStoreType.DEFAULT;
            }
            KeyStore ks = KeyStore.getInstance(keyStoreType.getValue());
            ks.load(loadStoreParameter);
            return ks;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static KeyStore loadKeyStore(byte[] data, String storeId, KeyStoreType keyStoreType, CallbackHandler storePassSrc) {
        return KeyStoreService.loadKeyStore(new ByteArrayInputStream(data), storeId, keyStoreType, storePassSrc);
    }

    public static void fillKeyStore(KeyStore ks, Collection<KeyEntry> keyEntries) {
        for (KeyEntry keyEntry : keyEntries) {
            KeyStoreService.addToKeyStore(ks, keyEntry);
        }
    }

    public static void addToKeyStore(KeyStore ks, KeyEntry keyEntry) {
        if (keyEntry instanceof KeyPairEntry) {
            KeyStoreService.addToKeyStore(ks, (KeyPairEntry)keyEntry);
        } else if (keyEntry instanceof SecretKeyEntry) {
            KeyStoreService.addToKeyStore(ks, (SecretKeyEntry)keyEntry);
        } else if (keyEntry instanceof TrustedCertEntry) {
            KeyStoreService.addToKeyStore(ks, (TrustedCertEntry)keyEntry);
        }
    }

    private static void addToKeyStore(KeyStore ks, KeyPairEntry keyPairHolder) {
        try {
            ArrayList<X509Certificate> chainList = new ArrayList<X509Certificate>();
            CertificationResult certification = keyPairHolder.getCertification();
            X509CertificateHolder subjectCert = certification != null ? certification.getSubjectCert() : keyPairHolder.getKeyPair().getSubjectCert();
            chainList.add(V3CertificateUtils.getX509JavaCertificate(subjectCert));
            if (certification != null) {
                List<X509CertificateHolder> issuerChain = certification.getIssuerChain();
                for (X509CertificateHolder x509CertificateHolder : issuerChain) {
                    chainList.add(V3CertificateUtils.getX509JavaCertificate(x509CertificateHolder));
                }
            }
            java.security.cert.Certificate[] chain = chainList.toArray(new java.security.cert.Certificate[chainList.size()]);
            ks.setKeyEntry(keyPairHolder.getAlias(), keyPairHolder.getKeyPair().getKeyPair().getPrivate(), PasswordCallbackUtils.getPassword(keyPairHolder.getPasswordSource(), keyPairHolder.getAlias()), chain);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void addToKeyStore(KeyStore ks, SecretKeyEntry secretKeyData) {
        KeyStore.SecretKeyEntry entry = new KeyStore.SecretKeyEntry(secretKeyData.getSecretKey());
        KeyStore.ProtectionParameter protParam = KeyStoreService.getPasswordProtectionParameter(secretKeyData.getPasswordSource(), secretKeyData.getAlias());
        try {
            ks.setEntry(secretKeyData.getAlias(), entry, protParam);
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException(e);
        }
    }

    private static KeyStore.ProtectionParameter getPasswordProtectionParameter(CallbackHandler passwordSource, String alias) {
        return new KeyStore.PasswordProtection(PasswordCallbackUtils.getPassword(passwordSource, alias));
    }

    private static void addToKeyStore(KeyStore ks, TrustedCertEntry trustedCertHolder) {
        try {
            ks.setCertificateEntry(trustedCertHolder.getAlias(), V3CertificateUtils.getX509JavaCertificate(trustedCertHolder.getCertificate()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static List<KeyEntry> loadEntries(KeyStore keyStore, PasswordProvider passwordProvider) {
        Enumeration<String> aliases;
        ArrayList<KeyEntry> keyEntries = new ArrayList<KeyEntry>();
        try {
            aliases = keyStore.aliases();
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        for (String alias : Collections.list(aliases)) {
            try {
                CallbackHandler passwordSource = passwordProvider.providePasswordCallbackHandler(alias);
                KeyStore.Entry entry = keyStore.getEntry(alias, KeyStoreService.getPasswordProtectionParameter(passwordSource, alias));
                KeyEntry keyEntry = KeyStoreService.createFromKeyStoreEntry(alias, entry, passwordSource);
                keyEntries.add(keyEntry);
            }
            catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException e) {
                throw new RuntimeException(e);
            }
        }
        return keyEntries;
    }

    public static Map<String, KeyEntry> loadEntryMap(KeyStore keyStore, PasswordProvider passwordProvider) {
        Enumeration<String> aliases;
        HashMap<String, KeyEntry> keyEntries = new HashMap<String, KeyEntry>();
        try {
            aliases = keyStore.aliases();
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        for (String alias : Collections.list(aliases)) {
            try {
                CallbackHandler passwordSource = passwordProvider.providePasswordCallbackHandler(alias);
                KeyStore.Entry entry = keyStore.getEntry(alias, KeyStoreService.getPasswordProtectionParameter(passwordSource, alias));
                KeyEntry keyEntry = KeyStoreService.createFromKeyStoreEntry(alias, entry, passwordSource);
                keyEntries.put(alias, keyEntry);
            }
            catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException e) {
                throw new RuntimeException(e);
            }
        }
        return keyEntries;
    }

    private static KeyEntry createFromKeyStoreEntry(String alias, KeyStore.Entry entry, CallbackHandler passwordSource) {
        if (entry instanceof KeyStore.PrivateKeyEntry) {
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)entry;
            return KeyStoreService.fromPrivateKeyEntry(alias, passwordSource, privateKeyEntry);
        }
        if (entry instanceof KeyStore.SecretKeyEntry) {
            KeyStore.SecretKeyEntry secretKeyEntry = (KeyStore.SecretKeyEntry)entry;
            SecretKey secretKey = secretKeyEntry.getSecretKey();
            return SecretKeyData.builder().alias(alias).passwordSource(passwordSource).secretKey(secretKey).keyAlgo(secretKey.getAlgorithm()).build();
        }
        if (entry instanceof KeyStore.TrustedCertificateEntry) {
            KeyStore.TrustedCertificateEntry trustedCertificateEntry = (KeyStore.TrustedCertificateEntry)entry;
            return TrustedCertData.builder().alias(alias).passwordSource(passwordSource).certificate(KeyStoreService.toX509CertificateHolder(trustedCertificateEntry.getTrustedCertificate())).build();
        }
        throw new RuntimeException("Unknown type: " + entry.getClass());
    }

    private static KeyPairEntry fromPrivateKeyEntry(String alias, CallbackHandler passwordSource, KeyStore.PrivateKeyEntry privateKeyEntry) {
        KeyPair keyPair = new KeyPair(privateKeyEntry.getCertificate().getPublicKey(), privateKeyEntry.getPrivateKey());
        X509CertificateHolder subjectCert = KeyStoreService.toX509CertificateHolder(privateKeyEntry.getCertificate());
        SelfSignedKeyPairData keyPairData = new SelfSignedKeyPairData(keyPair, subjectCert);
        CertificationResult certification = new CertificationResult(subjectCert, KeyStoreService.toX509CertificateHolders(privateKeyEntry.getCertificateChain()));
        return KeyPairData.builder().alias(alias).keyPair(keyPairData).certification(certification).passwordSource(passwordSource).build();
    }

    private static List<X509CertificateHolder> toX509CertificateHolders(java.security.cert.Certificate[] certificates) {
        return Arrays.stream(certificates).map(KeyStoreService::toX509CertificateHolder).collect(Collectors.toList());
    }

    private static X509CertificateHolder toX509CertificateHolder(java.security.cert.Certificate certificate) {
        Certificate bouncyCastleAsn1Certificate = null;
        try {
            bouncyCastleAsn1Certificate = Certificate.getInstance((Object)certificate.getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new RuntimeException(e);
        }
        return new X509CertificateHolder(bouncyCastleAsn1Certificate);
    }

    public static class SimplePasswordProvider
    implements PasswordProvider {
        private final CallbackHandler callbackHandler;

        public SimplePasswordProvider(char[] password) {
            this.callbackHandler = new PasswordCallbackHandler(password);
        }

        public SimplePasswordProvider(CallbackHandler callbackHandler) {
            this.callbackHandler = callbackHandler;
        }

        @Override
        public CallbackHandler providePasswordCallbackHandler(String keyAlias) {
            return this.callbackHandler;
        }
    }

    public static class PasswordProviderMap
    implements PasswordProvider {
        private final Map<String, char[]> passwordsForAlias;

        public PasswordProviderMap(Map<String, char[]> passwordsForAlias) {
            this.passwordsForAlias = passwordsForAlias;
        }

        @Override
        public CallbackHandler providePasswordCallbackHandler(String keyAlias) {
            char[] password = this.passwordsForAlias.get(keyAlias);
            if (password == null) {
                throw new RuntimeException("Password for alias '" + keyAlias + "' not found");
            }
            return new PasswordCallbackHandler(password);
        }
    }

    public static interface PasswordProvider {
        public CallbackHandler providePasswordCallbackHandler(String var1);
    }
}

