/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.cryptoutils;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.jwk.SecretJWK;
import java.security.Key;
import java.security.KeyPair;
import javax.crypto.spec.SecretKeySpec;
import org.adorsys.cryptoutils.exceptions.BaseException;

public class KeyConverter {
    public static Key toPrivateOrSecret(JWK jwk) {
        try {
            if (jwk instanceof RSAKey) {
                KeyPair keyPair = ((RSAKey)jwk).toKeyPair();
                if (keyPair.getPrivate() != null) {
                    return keyPair.getPrivate();
                }
            } else if (jwk instanceof SecretJWK) {
                return ((SecretJWK)jwk).toSecretKey();
            }
        }
        catch (JOSEException e) {
            return null;
        }
        return null;
    }

    public static Key toPrivateOrSecret(JWK jwk, String alg) {
        try {
            if (jwk instanceof RSAKey) {
                KeyPair keyPair = ((RSAKey)jwk).toKeyPair();
                if (keyPair.getPrivate() != null) {
                    return keyPair.getPrivate();
                }
            } else if (jwk instanceof SecretJWK) {
                byte[] encodedKey = ((SecretJWK)jwk).toSecretKey().getEncoded();
                return new SecretKeySpec(encodedKey, alg);
            }
        }
        catch (JOSEException e) {
            return null;
        }
        return null;
    }

    public static Key toPublic(JWK jwk) {
        block4: {
            try {
                if (jwk instanceof RSAKey) {
                    KeyPair keyPair = ((RSAKey)jwk).toKeyPair();
                    if (keyPair.getPublic() != null) {
                        return keyPair.getPublic();
                    }
                    break block4;
                }
                throw new BaseException("Cannot extract public key from non AssymetricJWK");
            }
            catch (JOSEException e) {
                return null;
            }
        }
        return null;
    }
}

