/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.common.converter;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.ECDSASigner;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jose.jwk.OctetSequenceKey;
import com.nimbusds.jose.jwk.PasswordLookup;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.jwk.SecretJWK;
import de.adorsys.sts.common.model.KeyAndJwk;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import javax.crypto.spec.SecretKeySpec;

public class KeyConverter {
    public static Key toPrivateOrSecret(JWK jwk) {
        try {
            if (jwk instanceof RSAKey) {
                KeyPair keyPair = ((RSAKey)jwk).toKeyPair();
                if (keyPair.getPrivate() != null) {
                    return keyPair.getPrivate();
                }
            } else if (jwk instanceof SecretJWK) {
                return ((SecretJWK)jwk).toSecretKey();
            }
        }
        catch (JOSEException e) {
            return null;
        }
        return null;
    }

    public static Key toPrivateOrSecret(JWK jwk, String alg) {
        try {
            if (jwk instanceof RSAKey) {
                KeyPair keyPair = ((RSAKey)jwk).toKeyPair();
                if (keyPair.getPrivate() != null) {
                    return keyPair.getPrivate();
                }
            } else if (jwk instanceof SecretJWK) {
                byte[] encodedKey = ((SecretJWK)jwk).toSecretKey().getEncoded();
                return new SecretKeySpec(encodedKey, alg);
            }
        }
        catch (JOSEException e) {
            return null;
        }
        return null;
    }

    public static Key toPublic(JWK jwk) {
        block4: {
            try {
                if (jwk instanceof RSAKey) {
                    KeyPair keyPair = ((RSAKey)jwk).toKeyPair();
                    if (keyPair.getPublic() != null) {
                        return keyPair.getPublic();
                    }
                    break block4;
                }
                throw new RuntimeException("Cannot extract public key from non AssymetricJWK");
            }
            catch (JOSEException e) {
                return null;
            }
        }
        return null;
    }

    public static JWKSet exportPrivateKeys(KeyStore keyStore, char[] keypass) {
        PasswordLookup pwLookup = name -> keypass;
        try {
            return JWKSet.load((KeyStore)keyStore, (PasswordLookup)pwLookup);
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException(e);
        }
    }

    public static JWSAlgorithm getJWSAlgo(KeyAndJwk randomKey) {
        Algorithm algorithm = randomKey.jwk.getAlgorithm();
        if (algorithm != null && algorithm instanceof JWSAlgorithm) {
            return (JWSAlgorithm)algorithm;
        }
        KeyType keyType = randomKey.jwk.getKeyType();
        if (keyType != null) {
            if (KeyType.RSA.equals((Object)keyType)) {
                return JWSAlgorithm.RS256;
            }
            if (KeyType.EC.equals((Object)keyType)) {
                return JWSAlgorithm.ES256;
            }
            if (KeyType.OCT.equals((Object)keyType)) {
                return JWSAlgorithm.HS256;
            }
            throw new IllegalStateException("Unknown key type: " + keyType);
        }
        if (randomKey.jwk instanceof RSAKey) {
            return JWSAlgorithm.RS256;
        }
        if (randomKey.jwk instanceof ECKey) {
            return JWSAlgorithm.ES256;
        }
        if (randomKey.jwk instanceof OctetSequenceKey) {
            return JWSAlgorithm.HS256;
        }
        throw new IllegalStateException("Unknown key type: " + randomKey.jwk.getClass().getName());
    }

    public static JWSSigner findSigner(KeyAndJwk randomKey) throws JOSEException {
        if (randomKey.jwk instanceof RSAKey) {
            return new RSASSASigner((RSAKey)randomKey.jwk);
        }
        if (randomKey.jwk instanceof ECKey) {
            return new ECDSASigner((ECKey)randomKey.jwk);
        }
        if (randomKey.jwk instanceof OctetSequenceKey) {
            return new MACSigner((OctetSequenceKey)randomKey.jwk);
        }
        throw new IllegalStateException("Unknown key type: " + randomKey.jwk.getClass().getName());
    }
}

