/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.common.config;

import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.KeySourceException;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import de.adorsys.sts.common.config.AuthServer;
import java.security.Key;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class MultiAuthJWSKeySelector<C extends SecurityContext>
implements JWSKeySelector<C> {
    private AuthServer authServer;

    public List<? extends Key> selectJWSKeys(JWSHeader header, C context) throws KeySourceException {
        String keyID = header.getKeyID();
        if (StringUtils.isBlank((CharSequence)keyID)) {
            return Collections.emptyList();
        }
        Key key = this.authServer.getJWK(keyID);
        if (key == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(key);
    }

    public MultiAuthJWSKeySelector(AuthServer authServer) {
        this.authServer = authServer;
    }
}

