/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.smartanalytics.config;

import de.adorsys.smartanalytics.web.UserResource;
import java.util.Arrays;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.AuthorizationCodeGrantBuilder;
import springfox.documentation.builders.OAuthBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.AuthorizationCodeGrant;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.Contact;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.service.SecurityScheme;
import springfox.documentation.service.TokenEndpoint;
import springfox.documentation.service.TokenRequestEndpoint;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger.web.SecurityConfiguration;
import springfox.documentation.swagger.web.SecurityConfigurationBuilder;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
@Profile(value={"swagger"})
public class SwaggerConfig {
    @Value(value="${idp.baseUrl}")
    private String loginUrl;
    @Value(value="${info.project.version}")
    private String version;
    @Value(value="${swagger.client.id:multibanking-client}")
    private String swaggerClientId;
    @Value(value="${idp.realm:multibanking}")
    private String realm;

    @Bean
    public Docket api() {
        return new Docket(DocumentationType.SWAGGER_2).apiInfo(this.apiInfo()).select().apis(RequestHandlerSelectors.withClassAnnotation(UserResource.class)).paths(PathSelectors.any()).build().securitySchemes(Collections.singletonList(this.securityScheme())).securityContexts(Collections.singletonList(this.securityContext()));
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title("Smartanalytics REST Api").contact(new Contact("Alexander Geist adorsys GmbH & Co. KG", null, "age@adorsys.de")).version(this.version).build();
    }

    private SecurityContext securityContext() {
        return SecurityContext.builder().securityReferences(Collections.singletonList(new SecurityReference("multibanking_auth", this.scopes()))).forPaths(PathSelectors.any()).build();
    }

    @Bean
    public SecurityConfiguration security() {
        return SecurityConfigurationBuilder.builder().clientId(this.swaggerClientId).build();
    }

    private SecurityScheme securityScheme() {
        String tokenEndpoint = String.format("%s/auth/realms/%s/protocol/openid-connect/token", this.loginUrl, this.realm);
        String tokenRequestEndpoint = String.format("%s/auth/realms/%s/protocol/openid-connect/auth", this.loginUrl, this.realm);
        AuthorizationCodeGrant grantType = new AuthorizationCodeGrantBuilder().tokenEndpoint(new TokenEndpoint(tokenEndpoint, "token")).tokenRequestEndpoint(new TokenRequestEndpoint(tokenRequestEndpoint, this.swaggerClientId, null)).build();
        return new OAuthBuilder().name("multibanking_auth").grantTypes(Collections.singletonList(grantType)).scopes(Arrays.asList(this.scopes())).build();
    }

    private AuthorizationScope[] scopes() {
        return new AuthorizationScope[]{new AuthorizationScope("openid", "openid connect")};
    }
}

