/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.smartanalytics.config;

import de.adorsys.smartanalytics.web.UserResource;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.ImplicitGrantBuilder;
import springfox.documentation.builders.OAuthBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.Contact;
import springfox.documentation.service.GrantType;
import springfox.documentation.service.ImplicitGrant;
import springfox.documentation.service.LoginEndpoint;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.service.SecurityScheme;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger.web.SecurityConfiguration;
import springfox.documentation.swagger.web.SecurityConfigurationBuilder;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
@Profile(value={"swagger"})
public class SwaggerConfig {
    @Value(value="${swagger.login.url}")
    private String loginUrl;
    @Value(value="${info.project.version}")
    private String version;

    @Bean
    public Docket api() {
        return new Docket(DocumentationType.SWAGGER_2).apiInfo(new ApiInfoBuilder().title("Smartanalytics REST Api").contact(new Contact("Alexander Geist adorsys GmbH & Co. KG", null, "age@adorsys.de")).version(this.version).build()).select().apis(RequestHandlerSelectors.withClassAnnotation(UserResource.class)).paths(PathSelectors.any()).build().securitySchemes(Arrays.asList(this.oauth())).securityContexts(Arrays.asList(this.securityContext()));
    }

    @Bean
    public SecurityContext securityContext() {
        AuthorizationScope[] scopes = new AuthorizationScope[]{new AuthorizationScope("openid", "openid connect")};
        SecurityReference securityReference = SecurityReference.builder().reference("multibanking_auth").scopes(scopes).build();
        return SecurityContext.builder().securityReferences(Arrays.asList(securityReference)).forPaths(PathSelectors.ant((String)"*")).build();
    }

    @Bean
    public SecurityConfiguration security() {
        return SecurityConfigurationBuilder.builder().appName("Smartanalytics swagger client").realm("multibanking").clientId("multibanking-client").build();
    }

    @Bean
    public SecurityScheme oauth() {
        return new OAuthBuilder().name("multibanking_auth").scopes(Arrays.asList(new AuthorizationScope("openid", "openid connect"))).grantTypes(this.grantTypes()).build();
    }

    private List<GrantType> grantTypes() {
        ImplicitGrant grantType = new ImplicitGrantBuilder().loginEndpoint(new LoginEndpoint(this.loginUrl)).build();
        return Arrays.asList(grantType);
    }
}

