/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.smartanalytics.config;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import de.adorsys.smartanalytics.config.EnableSmartanalyticsMongoPersistence;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.Environment;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.config.AbstractMongoConfiguration;
import org.springframework.data.mongodb.core.SimpleMongoDbFactory;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.gridfs.GridFsTemplate;

@Configuration
@EnableSmartanalyticsMongoPersistence
@PropertySource(value={"${mongo.properties.url}"}, ignoreResourceNotFound=true)
@Profile(value={"mongo-persistence"})
public class MongoConfig
extends AbstractMongoConfiguration {
    @Autowired
    private Environment env;

    protected String getDatabaseName() {
        return this.env.getProperty("mongo.databaseName");
    }

    @Bean
    public GridFsTemplate gridFsTemplate() throws Exception {
        return new GridFsTemplate(this.mongoDbFactory(), (MongoConverter)this.mappingMongoConverter());
    }

    @Bean
    public MongoClient mongoClient() {
        MongoClientOptions mongoClientOptions = new MongoClientOptions.Builder().connectionsPerHost(50).writeConcern(WriteConcern.JOURNALED).readPreference(ReadPreference.secondaryPreferred()).build();
        ServerAddress serverAddress = this.getServerAddress();
        if (StringUtils.isEmpty((CharSequence)this.env.getProperty("mongo.userName"))) {
            return new MongoClient(serverAddress, mongoClientOptions);
        }
        MongoCredential mongoCredential = MongoCredential.createCredential((String)this.env.getProperty("mongo.userName"), (String)this.env.getProperty("mongo.databaseName"), (char[])this.env.getProperty("mongo.password").toCharArray());
        return new MongoClient(serverAddress, mongoCredential, mongoClientOptions);
    }

    private ServerAddress getServerAddress() {
        String[] serverParts = this.env.getProperty("mongo.server").replace("mongodb://", "").split(":");
        return new ServerAddress(serverParts[0], 1 < serverParts.length ? Integer.valueOf(serverParts[1]) : ServerAddress.defaultPort());
    }

    public MongoDbFactory mongoDbFactory() {
        return new SimpleMongoDbFactory(this.mongoClient(), this.env.getProperty("mongo.databaseName"));
    }
}

