/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.smartanalytics.pers.mongo;

import de.adorsys.smartanalytics.pers.api.RuleEntity;
import de.adorsys.smartanalytics.pers.mongo.RuleRepositoryMongodb;
import de.adorsys.smartanalytics.pers.spi.RuleRepositoryIf;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Profile(value={"mongo-persistence", "fongo"})
@Service
public class RuleRepositoryImpl
implements RuleRepositoryIf {
    @Autowired
    private RuleRepositoryMongodb ruleRepositoryMongo;
    @Autowired
    private MongoTemplate mongoTemplate;

    @Override
    public long count() {
        return this.ruleRepositoryMongo.count();
    }

    @Override
    public void deleteAll() {
        this.ruleRepositoryMongo.deleteAll();
    }

    @Override
    public void saveAll(List<RuleEntity> rules) {
        this.ruleRepositoryMongo.saveAll(rules);
    }

    @Override
    public void save(RuleEntity ruleEntity) {
        this.ruleRepositoryMongo.save((Object)ruleEntity);
    }

    @Override
    public List<RuleEntity> findAll() {
        return this.ruleRepositoryMongo.findAll();
    }

    @Override
    public void deleteById(String id) {
        this.ruleRepositoryMongo.deleteById(id);
    }

    @Override
    public Page<RuleEntity> findAll(Pageable pageable) {
        return this.ruleRepositoryMongo.findAll(pageable);
    }

    @Override
    public Optional<RuleEntity> getRuleByRuleId(String ruleId) {
        return this.ruleRepositoryMongo.getRuleByRuleId(ruleId);
    }

    @Override
    public Iterable<RuleEntity> search(String search) {
        HashSet<String> terms = new HashSet<String>(Arrays.asList(search.split(" ")));
        Criteria[] criterias = (Criteria[])terms.stream().map(s -> Criteria.where((String)"searchIndex").regex(s.toLowerCase(), "iu")).toArray(Criteria[]::new);
        return this.mongoTemplate.find(Query.query((CriteriaDefinition)new Criteria().andOperator(criterias)).with(Sort.by((String[])new String[]{"order"})), RuleEntity.class);
    }
}

