/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.smartanalytics.pers.mongo;

import de.adorsys.smartanalytics.pers.spi.ImageRepositoryIf;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Profile;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.gridfs.GridFsTemplate;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;

@Profile(value={"mongo-persistence", "fongo"})
@Service
public class ImageRepositoryImpl
implements ImageRepositoryIf {
    private static final Logger log = LoggerFactory.getLogger(ImageRepositoryImpl.class);
    private final GridFsTemplate gridFsTemplate;

    @Override
    @Nullable
    public byte[] getImage(String filename) {
        return Optional.ofNullable(this.gridFsTemplate.getResource(filename)).map(gridFsResource -> {
            try {
                return IOUtils.toByteArray((InputStream)gridFsResource.getInputStream());
            }
            catch (IOException e) {
                log.warn(e.getMessage());
                return null;
            }
        }).orElse(null);
    }

    @Override
    public void saveImage(byte[] byteArray, String fileName) {
        this.gridFsTemplate.store((InputStream)new ByteArrayInputStream(byteArray), fileName);
    }

    @Override
    public void deleteAllImages() {
        this.gridFsTemplate.delete(new Query());
    }

    public ImageRepositoryImpl(GridFsTemplate gridFsTemplate) {
        this.gridFsTemplate = gridFsTemplate;
    }
}

