/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.smartanalytics.pers.mongo;

import de.adorsys.smartanalytics.api.BookingGroupConfig;
import de.adorsys.smartanalytics.pers.api.BookingGroupConfigEntity;
import de.adorsys.smartanalytics.pers.mongo.BookingGroupsRepositoryMongodb;
import de.adorsys.smartanalytics.pers.spi.BookingGroupRepositoryIf;
import java.time.LocalDate;
import java.util.Optional;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Profile(value={"mongo-persistence", "fongo"})
@Service
public class BookingGroupsRepositoryImpl
implements BookingGroupRepositoryIf {
    @Autowired
    private BookingGroupsRepositoryMongodb groupsRepository;

    @Override
    public Optional<BookingGroupConfigEntity> getBookingGroups() {
        return this.groupsRepository.findById("groups");
    }

    @Override
    public void saveBookingGroups(BookingGroupConfig groupsContainer) {
        BookingGroupConfigEntity containerEntity = new BookingGroupConfigEntity();
        BeanUtils.copyProperties((Object)groupsContainer, (Object)((Object)containerEntity));
        containerEntity.setId("groups");
        containerEntity.setChangeDate(LocalDate.now());
        this.groupsRepository.deleteById("groups");
        this.groupsRepository.save((Object)containerEntity);
    }
}

