/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.smartanalytics.pers.file;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import de.adorsys.smartanalytics.pers.api.ConfigStatusEntity;
import de.adorsys.smartanalytics.pers.spi.StatusRepositoryIf;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

@Profile(value={"fs-persistence"})
@Service
public class StatusRepositoryImpl
implements StatusRepositoryIf {
    private static final Logger log = LoggerFactory.getLogger(StatusRepositoryImpl.class);
    @Value(value="file:/tmp/status.yml")
    private Resource statusResource;
    private ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    private ConfigStatusEntity statusEntity;

    @PostConstruct
    public void postConstruct() throws IOException {
        this.objectMapper.findAndRegisterModules();
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        if (!this.statusResource.getFile().exists()) {
            log.warn("status file {} not exists", (Object)this.statusResource.getFile().getAbsolutePath());
            return;
        }
        String rulesString = IOUtils.toString((InputStream)this.statusResource.getInputStream(), (Charset)StandardCharsets.UTF_8);
        this.statusEntity = (ConfigStatusEntity)((Object)this.objectMapper.readValue(rulesString, ConfigStatusEntity.class));
    }

    @Override
    public Optional<ConfigStatusEntity> findById(String statusId) {
        return Optional.ofNullable(this.statusEntity);
    }

    @Override
    public void save(ConfigStatusEntity statusEntity) {
        this.statusEntity = statusEntity;
        this.dumpToFile();
    }

    private void dumpToFile() {
        try {
            this.objectMapper.writeValue(this.statusResource.getFile(), (Object)this.statusEntity);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

