/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.smartanalytics.pers.file;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import de.adorsys.smartanalytics.pers.api.RuleEntity;
import de.adorsys.smartanalytics.pers.spi.RuleRepositoryIf;
import de.adorsys.smartanalytics.pers.utils.ImportUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.core.io.Resource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Profile(value={"fs-persistence"})
@Repository
public class RuleRepositoryImpl
implements RuleRepositoryIf {
    private static final Logger log = LoggerFactory.getLogger(RuleRepositoryImpl.class);
    @Value(value="file:/tmp/rules.yml")
    private Resource rulesResource;
    private ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    private List<RuleEntity> rules;

    @PostConstruct
    public void postConstruct() throws IOException {
        if (!this.rulesResource.getFile().exists()) {
            this.rules = new ArrayList<RuleEntity>();
            log.warn("rules file {} not exists", (Object)this.rulesResource.getFile().getAbsolutePath());
            return;
        }
        this.rules = ImportUtils.importYamlRules(IOUtils.toString((InputStream)this.rulesResource.getInputStream(), (Charset)StandardCharsets.UTF_8));
    }

    @Override
    public long count() {
        return this.rules.size();
    }

    @Override
    public void deleteAll() {
        this.rules = new ArrayList<RuleEntity>();
        this.dumpToFile();
    }

    @Override
    public void saveAll(List<RuleEntity> rules) {
        this.rules = rules;
        this.dumpToFile();
    }

    @Override
    public void save(RuleEntity ruleEntity) {
        if (ruleEntity.getId() == null) {
            ruleEntity.setId(UUID.randomUUID().toString());
            this.rules.add(ruleEntity);
        } else {
            this.rules.removeIf(x -> x.getId().equals(ruleEntity.getId()));
            this.rules.add(ruleEntity);
        }
        this.dumpToFile();
    }

    @Override
    public List<RuleEntity> findAll() {
        return this.rules;
    }

    @Override
    public void deleteById(String id) {
        this.rules.removeIf(x -> x.getId().equals(id));
        this.dumpToFile();
    }

    @Override
    public Page<RuleEntity> findAll(Pageable pageable) {
        return this.createPage(pageable, this.rules);
    }

    @Override
    public Optional<RuleEntity> getRuleByRuleId(String ruleId) {
        return this.rules.stream().filter(ruleEntity -> ruleEntity.getRuleId().equals(ruleId)).findFirst();
    }

    @Override
    public Iterable<RuleEntity> search(String query) {
        Pattern pattern = Pattern.compile(query, 2);
        return this.rules.stream().filter(ruleEntity -> ruleEntity.getSearchIndex().stream().anyMatch(s -> pattern.matcher((CharSequence)s).find())).collect(Collectors.toList());
    }

    private PageImpl<RuleEntity> createPage(Pageable pageable, List<RuleEntity> rules) {
        List<RuleEntity> result = this.subList(rules.iterator(), pageable.getOffset(), pageable.getPageSize());
        return new PageImpl(result, pageable, (long)rules.size());
    }

    private List<RuleEntity> subList(Iterator<RuleEntity> source, long skip, int limit) {
        ArrayList<RuleEntity> result = new ArrayList<RuleEntity>();
        while (source.hasNext()) {
            RuleEntity t = source.next();
            if (skip > 0L) {
                --skip;
            } else {
                result.add(t);
                --limit;
            }
            if ((long)limit + skip != 0L) continue;
            break;
        }
        return result;
    }

    private void dumpToFile() {
        try {
            this.objectMapper.writeValue(this.rulesResource.getFile(), this.rules);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

