/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.smartanalytics.web;

import de.adorsys.smartanalytics.core.RulesProvider;
import de.adorsys.smartanalytics.core.RulesService;
import de.adorsys.smartanalytics.exception.InvalidRulesException;
import de.adorsys.smartanalytics.exception.ResourceNotFoundException;
import de.adorsys.smartanalytics.pers.api.RuleEntity;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.Resources;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(path={"api/v1/rules"})
public class RulesController {
    private static final Logger log = LoggerFactory.getLogger(RulesController.class);
    @Autowired
    private RulesProvider rulesProvider;
    @Autowired
    private RulesService rulesService;

    @RequestMapping(method={RequestMethod.GET})
    public PagedResources<Resource<RuleEntity>> getRules(@PageableDefault(size=20) Pageable pageable, PagedResourcesAssembler<RuleEntity> assembler) {
        Page<RuleEntity> pageableResult = this.rulesService.findAll(pageable);
        return assembler.toResource(pageableResult);
    }

    @RequestMapping(value={"/{ruleId}"}, method={RequestMethod.GET})
    public Resource<RuleEntity> getRule(@PathVariable String ruleId) {
        RuleEntity ruleEntity = this.rulesService.getRuleByRuleId(ruleId).orElseThrow(() -> new ResourceNotFoundException(RuleEntity.class, ruleId));
        return this.mapToResource(ruleEntity);
    }

    @RequestMapping(method={RequestMethod.POST})
    public HttpEntity<Void> createRule(@RequestBody RuleEntity ruleEntity) {
        ruleEntity.updateSearchIndex();
        this.rulesService.save(ruleEntity);
        return new ResponseEntity(HttpStatus.CREATED);
    }

    @RequestMapping(value={"/{ruleId}"}, method={RequestMethod.PUT})
    public HttpEntity<Void> updateRule(@PathVariable String ruleId, @RequestBody RuleEntity ruleEntity) {
        ruleEntity.updateSearchIndex();
        this.rulesService.save(ruleEntity);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"/{ruleId}"}, method={RequestMethod.DELETE})
    public HttpEntity<Void> deleteRule(@PathVariable String ruleId) {
        this.rulesService.deleteById(ruleId);
        log.info("Rule [{}] deleted.", (Object)ruleId);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    public Resources<RuleEntity> searchRules(@RequestParam String query) {
        return new Resources(this.rulesService.search(query), new Link[0]);
    }

    @RequestMapping(path={"/download"}, method={RequestMethod.GET}, produces={"application/octet-stream"})
    public HttpEntity<InputStreamResource> downloadRules(@RequestParam(required=false, defaultValue="CSV") RulesService.FileFormat format) throws IOException {
        return ResponseEntity.ok().body((Object)new InputStreamResource((InputStream)new ByteArrayInputStream(this.rulesService.rulesAsByteArray(format))));
    }

    @RequestMapping(path={"/upload"}, method={RequestMethod.POST})
    public HttpEntity<?> uploadRules(@RequestParam MultipartFile rulesFile) {
        if (!rulesFile.isEmpty()) {
            try {
                this.rulesService.newRules(rulesFile.getOriginalFilename(), rulesFile.getInputStream());
                return new ResponseEntity(HttpStatus.CREATED);
            }
            catch (Exception e) {
                log.error("unable import rules", (Throwable)e);
                throw new InvalidRulesException(rulesFile.getOriginalFilename());
            }
        }
        throw new InvalidRulesException("File is empty");
    }

    private List<Resource> mapToResources(List<RuleEntity> entities) {
        return entities.stream().map(this::mapToResource).collect(Collectors.toList());
    }

    private Resource<RuleEntity> mapToResource(RuleEntity entity) {
        return new Resource((Object)entity, new Link[]{ControllerLinkBuilder.linkTo(((RulesController)ControllerLinkBuilder.methodOn(RulesController.class, (Object[])new Object[0])).getRule(entity.getId())).withSelfRel()});
    }
}

