/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.smartanalytics.core;

import de.adorsys.smartanalytics.pers.api.StatusEntity;
import de.adorsys.smartanalytics.pers.spi.RuleRepositoryIf;
import de.adorsys.smartanalytics.pers.spi.StatusRepositoryIf;
import java.time.LocalDateTime;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StatusService {
    @Autowired
    private StatusRepositoryIf statusRepo;
    @Autowired
    private RuleRepositoryIf ruleRepository;

    public StatusEntity getStatus() {
        return this.statusRepo.findById("status").orElseGet(() -> {
            StatusEntity statusEntity = new StatusEntity();
            statusEntity.setId("status");
            statusEntity.setCountRules(this.ruleRepository.count());
            this.statusRepo.save(statusEntity);
            return statusEntity;
        });
    }

    public void rulesChanged() {
        this.rulesChanged(null);
    }

    public void rulesChanged(String version) {
        this.rulesChanged(version, this.ruleRepository.count());
    }

    private void rulesChanged(String version, long countRules) {
        StatusEntity status = this.getStatus();
        if (status.getVersion() == null && version == null) {
            status.setVersion(LocalDateTime.now().toString());
        } else if (status.getVersion() != null && version == null) {
            status.setVersion(StringUtils.substringBeforeLast((String)status.getVersion(), (String)"_") + "_" + LocalDateTime.now().toString());
        } else if (version != null) {
            status.setVersion(version);
        }
        status.setCountRules(countRules);
        status.setLastChangeDate(LocalDateTime.now());
        this.statusRepo.save(status);
    }
}

