/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.smartanalytics.core;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SequenceWriter;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import de.adorsys.smartanalytics.api.Rule;
import de.adorsys.smartanalytics.core.RulesProvider;
import de.adorsys.smartanalytics.core.StatusService;
import de.adorsys.smartanalytics.pers.api.RuleEntity;
import de.adorsys.smartanalytics.pers.spi.RuleRepositoryIf;
import de.adorsys.smartanalytics.pers.utils.ImportUtils;
import de.adorsys.smartanalytics.pers.utils.RuleMixIn;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class RulesService {
    private static final Logger log = LoggerFactory.getLogger(RulesService.class);
    @Autowired
    private RuleRepositoryIf rulesRepository;
    @Autowired
    private RuleRepositoryIf rulesRepositoryCustom;
    @Autowired
    private RulesProvider rulesProvider;
    @Autowired
    private StatusService statusService;

    public void newRules(String fileName, InputStream inputStream) throws IOException {
        List rules = ImportUtils.importRules((InputStream)inputStream);
        rules.forEach(RuleEntity::updateSearchIndex);
        log.info("new [{}] rules", (Object)rules.size());
        this.rulesRepository.deleteAll();
        this.rulesRepository.saveAll(rules);
        this.rulesProvider.initRules(rules);
        this.statusService.rulesChanged(FilenameUtils.getBaseName((String)fileName));
    }

    public byte[] rulesAsByteArray(FileFormat format) throws IOException {
        List<RuleEntity> rules = this.rulesProvider.getRules();
        if (format == FileFormat.YAML) {
            YAMLFactory ymlFactory = new YAMLFactory();
            ObjectMapper objectMapper = new ObjectMapper((JsonFactory)ymlFactory);
            return objectMapper.writeValueAsBytes(rules);
        }
        return this.rulesToCsv(rules, Rule.class, RuleMixIn.class);
    }

    private byte[] rulesToCsv(List<?> list, Class<?> type, Class<?> mixin) throws IOException {
        CsvMapper csvMapper = new CsvMapper();
        CsvSchema csvSchema = csvMapper.schemaFor(type).withHeader().withColumnSeparator(';');
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (SequenceWriter csvWriter = csvMapper.addMixIn(type, mixin).writerWithDefaultPrettyPrinter().with((FormatSchema)csvSchema).forType(type).writeValues((OutputStream)outputStream);){
            for (Object nextRow : list) {
                csvWriter.write(nextRow);
            }
        }
        return outputStream.toByteArray();
    }

    public Page<RuleEntity> findAll(Pageable pageable) {
        return this.rulesRepository.findAll(pageable);
    }

    public Optional<RuleEntity> getRuleByRuleId(String ruleId) {
        return this.rulesRepository.getRuleByRuleId(ruleId);
    }

    public void save(RuleEntity ruleEntity) {
        this.rulesRepository.save(ruleEntity);
        this.rulesProvider.initRules(this.rulesRepository.findAll());
        this.statusService.rulesChanged();
    }

    public void deleteById(String id) {
        this.rulesRepository.deleteById(id);
        this.rulesProvider.initRules(this.rulesRepository.findAll());
        this.statusService.rulesChanged();
    }

    public Iterable<RuleEntity> search(String query) {
        return this.rulesRepositoryCustom.search(query);
    }

    public static enum FileFormat {
        CSV,
        YAML;

    }
}

