/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.smartanalytics.core;

import de.adorsys.smartanalytics.CategorizationService;
import de.adorsys.smartanalytics.ClassificationService;
import de.adorsys.smartanalytics.api.AnalyticsRequest;
import de.adorsys.smartanalytics.api.AnalyticsResult;
import de.adorsys.smartanalytics.api.Booking;
import de.adorsys.smartanalytics.api.BookingGroup;
import de.adorsys.smartanalytics.api.GroupConfig;
import de.adorsys.smartanalytics.api.Rule;
import de.adorsys.smartanalytics.api.RulesStatus;
import de.adorsys.smartanalytics.api.WrappedBooking;
import de.adorsys.smartanalytics.core.RulesProvider;
import de.adorsys.smartanalytics.core.StatusService;
import de.adorsys.smartanalytics.group.CustomGroupBuilder;
import de.adorsys.smartanalytics.group.GroupBuilder;
import de.adorsys.smartanalytics.group.OtherBookingsGroupBuilder;
import de.adorsys.smartanalytics.group.RecurrentIncomeGroupBuilder;
import de.adorsys.smartanalytics.group.RecurrentNonSepaGroupBuilder;
import de.adorsys.smartanalytics.group.RecurrentSepaGroupBuilder;
import de.adorsys.smartanalytics.group.StandingOrderGroupBuilder;
import de.adorsys.smartanalytics.matcher.BookingMatcher;
import de.adorsys.smartanalytics.matcher.ExpressionMatcher;
import de.adorsys.smartanalytics.modifier.PaypalReceiverModifier;
import de.adorsys.smartanalytics.modifier.RulesModifier;
import de.adorsys.smartanalytics.utils.RulesFactory;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="smartanalytics")
public class AnalyticsService {
    private static final Logger log = LoggerFactory.getLogger(AnalyticsService.class);
    @Autowired
    private RulesProvider rulesProvider;
    @Autowired
    private StatusService statusService;

    public AnalyticsResult analytics(AnalyticsRequest request) {
        List<WrappedBooking> categorizedBookings = this.categorize(request.getBookings(), request.getCustomRules());
        List<BookingGroup> groups = this.groupBookings(request, categorizedBookings);
        AnalyticsResult analyticsResult = new AnalyticsResult();
        analyticsResult.setBookings(categorizedBookings);
        analyticsResult.setBookingGroups(groups);
        analyticsResult.setRulesStatus((RulesStatus)this.statusService.getStatus());
        return analyticsResult;
    }

    private List<BookingGroup> groupBookings(AnalyticsRequest request, List<WrappedBooking> categorizedBookings) {
        List<GroupBuilder> builderList = this.getGroupBuilders(request.getGroupConfig());
        List groupWhiteListMatcher = request.getGroupConfig().getRecurrentWhiteListMatcher().stream().map(RulesFactory::createExpressionMatcher).collect(Collectors.toList());
        List contractBlackListMatcher = request.getContractBlackListMatcher().stream().map(RulesFactory::createExpressionMatcher).collect(Collectors.toList());
        return new ClassificationService().group(categorizedBookings, builderList, groupWhiteListMatcher, contractBlackListMatcher);
    }

    private List<GroupBuilder> getGroupBuilders(GroupConfig groupConfig) {
        return groupConfig.getGroups().stream().map(group -> {
            switch (group.getType()) {
                case RECURRENT_SEPA: {
                    List matchers = group.getBlacklistMatcher().stream().map(RulesFactory::createExpressionMatcher).collect(Collectors.toList());
                    return new RecurrentSepaGroupBuilder(group.getName(), matchers);
                }
                case STANDING_ORDER: {
                    return new StandingOrderGroupBuilder(group.getName());
                }
                case RECURRENT_INCOME: {
                    return new RecurrentIncomeGroupBuilder(group.getName());
                }
                case RECURRENT_NONSEPA: {
                    List matchers = group.getBlacklistMatcher().stream().map(RulesFactory::createExpressionMatcher).collect(Collectors.toList());
                    return new RecurrentNonSepaGroupBuilder(group.getName(), matchers);
                }
                case CUSTOM: {
                    List matchers = group.getWhitelistMatcher().stream().map(RulesFactory::createExpressionMatcher).collect(Collectors.toList());
                    return new CustomGroupBuilder(group.getName(), matchers);
                }
                case OTHER_INCOME: {
                    return new OtherBookingsGroupBuilder(group.getName(), true);
                }
                case OTHER_EXPENSES: {
                    return new OtherBookingsGroupBuilder(group.getName(), false);
                }
            }
            throw new IllegalArgumentException("invalid group type: " + group.getType());
        }).collect(Collectors.toList());
    }

    private List<WrappedBooking> categorize(List<Booking> bookings, List<Rule> customRules) {
        ArrayList<BookingMatcher> incomingRules = new ArrayList<BookingMatcher>();
        ArrayList<BookingMatcher> expensesRules = new ArrayList<BookingMatcher>();
        customRules.forEach(customRule -> {
            try {
                ExpressionMatcher matcher;
                Object object = matcher = customRule.getSimilarityMatchType() == null ? RulesFactory.createExpressionMatcher((Rule)customRule) : RulesFactory.createSimilarityMatcher((Rule)customRule);
                if (customRule.isIncoming()) {
                    incomingRules.add((BookingMatcher)matcher);
                } else {
                    expensesRules.add((BookingMatcher)matcher);
                }
            }
            catch (Exception e) {
                log.warn("invalid customRule [{}]", (Object)customRule.getRuleId());
            }
        });
        incomingRules.addAll(this.rulesProvider.getIncomingRules());
        expensesRules.addAll(this.rulesProvider.getExpensesRules());
        ArrayList<Object> modifier = new ArrayList<Object>();
        modifier.add(new RulesModifier(expensesRules, booking -> booking.getAmount() == null || booking.getAmount().compareTo(new BigDecimal("0.00")) < 0));
        modifier.add(new RulesModifier(incomingRules, booking -> booking.getAmount() != null && booking.getAmount().compareTo(new BigDecimal("0.00")) >= 0));
        modifier.add(new PaypalReceiverModifier());
        return new CategorizationService().categorize(bookings, modifier);
    }
}

