/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.smartanalytics.core;

import de.adorsys.smartanalytics.api.Rule;
import de.adorsys.smartanalytics.matcher.BookingMatcher;
import de.adorsys.smartanalytics.matcher.ExpressionMatcher;
import de.adorsys.smartanalytics.pers.api.RuleEntity;
import de.adorsys.smartanalytics.pers.spi.RuleRepositoryIf;
import de.adorsys.smartanalytics.utils.RulesFactory;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RulesProvider {
    private static final Logger log = LoggerFactory.getLogger(RulesProvider.class);
    @Autowired
    private RuleRepositoryIf ruleRepository;
    private List<RuleEntity> rules;
    private List<BookingMatcher> incomingRules;
    private List<BookingMatcher> expensesRules;

    @PostConstruct
    public void postConstruct() {
        this.initRules(this.ruleRepository.findAll());
    }

    void initRules(List<RuleEntity> rules) {
        this.incomingRules = new ArrayList<BookingMatcher>();
        this.expensesRules = new ArrayList<BookingMatcher>();
        rules.forEach(rule -> {
            try {
                ExpressionMatcher matcher;
                Object object = matcher = rule.getSimilarityMatchType() == null ? RulesFactory.createExpressionMatcher((Rule)rule) : RulesFactory.createSimilarityMatcher((Rule)rule);
                if (rule.isIncoming()) {
                    this.incomingRules.add((BookingMatcher)matcher);
                } else {
                    this.expensesRules.add((BookingMatcher)matcher);
                }
            }
            catch (Exception e) {
                log.warn("invalid rule [{}]", (Object)rule.getRuleId(), (Object)e);
            }
        });
        this.rules = rules;
        log.info("initialized [{}] rules", (Object)rules.size());
    }

    List<BookingMatcher> getIncomingRules() {
        return this.incomingRules;
    }

    List<BookingMatcher> getExpensesRules() {
        return this.expensesRules;
    }

    public List<RuleEntity> getRules() {
        return this.rules;
    }
}

