/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.smartanalytics.rule;

import de.adorsys.smartanalytics.api.WrappedBooking;
import org.apache.commons.lang3.StringUtils;

enum Attribute {
    AMOUNT{

        @Override
        public String value(WrappedBooking input) {
            return String.valueOf(input.getAmount());
        }
    }
    ,
    RFN{

        @Override
        public String value(WrappedBooking input) {
            return Attribute.normalize(input.getReferenceName());
        }
    }
    ,
    GID{

        @Override
        public String value(WrappedBooking input) {
            return Attribute.normalize(input.getCreditorId());
        }
    }
    ,
    VWZ{

        @Override
        public String value(WrappedBooking input) {
            return Attribute.normalize(input.getPurpose());
        }
    }
    ,
    IBAN{

        @Override
        public String value(WrappedBooking input) {
            return Attribute.normalize(input.getIban());
        }
    }
    ,
    KTO{

        @Override
        public String value(WrappedBooking input) {
            return input.getAccountNumber();
        }
    }
    ,
    BLZ{

        @Override
        public String value(WrappedBooking input) {
            return input.getBankCode();
        }
    }
    ,
    HKAT{

        @Override
        public String value(WrappedBooking input) {
            return Attribute.normalize(input.getMainCategory());
        }
    }
    ,
    UKAT{

        @Override
        public String value(WrappedBooking input) {
            return Attribute.normalize(input.getSubCategory());
        }
    }
    ,
    SPEZ{

        @Override
        public String value(WrappedBooking input) {
            return Attribute.normalize(input.getSpecification());
        }
    };


    public abstract String value(WrappedBooking var1);

    private static String normalize(String s) {
        String output = StringUtils.trimToEmpty((String)s).toUpperCase();
        output = StringUtils.replace((String)output, (String)"\u00c4", (String)"AE");
        output = StringUtils.replace((String)output, (String)"\u00d6", (String)"OE");
        output = StringUtils.replace((String)output, (String)"\u00dc", (String)"UE");
        output = StringUtils.replace((String)output, (String)"\u00df", (String)"SS");
        return output;
    }
}

