/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.smartanalytics.modifier;

import de.adorsys.smartanalytics.api.WrappedBooking;
import de.adorsys.smartanalytics.matcher.BookingMatcher;
import de.adorsys.smartanalytics.modifier.Filter;
import de.adorsys.smartanalytics.modifier.Modifier;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RulesModifier
implements Modifier {
    private static final Logger log = LoggerFactory.getLogger(RulesModifier.class);
    private List<? extends BookingMatcher> matchers;
    private Filter filter;

    public RulesModifier(List<? extends BookingMatcher> matchers, Filter filter) {
        this(matchers);
        this.filter = filter;
    }

    public RulesModifier(List<? extends BookingMatcher> matchers) {
        this.matchers = matchers;
    }

    @Override
    public void modify(WrappedBooking booking) {
        if (this.filter == null || this.filter.filter(booking.getBooking())) {
            this.useRulesOn(booking);
        }
    }

    public boolean useRulesOn(WrappedBooking wrappedBooking) {
        for (BookingMatcher bookingMatcher : this.matchers) {
            try {
                if (bookingMatcher == null || !bookingMatcher.match(wrappedBooking)) continue;
                bookingMatcher.extend(wrappedBooking);
                if (!bookingMatcher.isFinal()) continue;
                return true;
            }
            catch (Exception e) {
                log.error("invalid matcher {}", (Object)bookingMatcher.getId());
            }
        }
        return false;
    }
}

