/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.smartanalytics.modifier;

import de.adorsys.smartanalytics.api.WrappedBooking;
import de.adorsys.smartanalytics.modifier.Modifier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class PaypalReceiverModifier
implements Modifier {
    private static final Pattern PAYPAL_PURPOSE_PATTERN = Pattern.compile(".*?(PP).*(PP\\s?.\\s?)(.*)(,\\s?Ihr).*", 2);

    @Override
    public void modify(WrappedBooking booking) {
        Matcher matcher;
        if (StringUtils.startsWithIgnoreCase((CharSequence)booking.getReferenceName(), (CharSequence)"PayPal") && booking.getPurpose() != null && (matcher = PAYPAL_PURPOSE_PATTERN.matcher(booking.getPurpose())).matches() && matcher.groupCount() == 4) {
            booking.setOtherAccount("PayPal Zahlung an " + matcher.group(3));
        }
    }
}

