/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.smartanalytics.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CreditorIdExtractor {
    private static Pattern creditorIdRegex = Pattern.compile("([deDE]{2}[0-9]{2,2}[A-Za-z0-9]{3,3}[0]{1}[0-9]{10})", 2);

    public static String extractCreditorId(String input) {
        if (input == null) {
            return null;
        }
        Matcher matcher = creditorIdRegex.matcher(input);
        if (matcher.find()) {
            return matcher.group(0);
        }
        return null;
    }

    public static boolean isValidCreditorId(String input) {
        if (input == null) {
            return false;
        }
        return CreditorIdExtractor.extractCreditorId(input) != null;
    }
}

