/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.smartanalytics.rule;

import de.adorsys.smartanalytics.api.Matcher;
import de.adorsys.smartanalytics.api.Rule;
import de.adorsys.smartanalytics.api.WrappedBooking;
import de.adorsys.smartanalytics.matcher.ExpressionMatcher;
import de.adorsys.smartanalytics.rule.Operator;
import de.adorsys.smartanalytics.rule.syntax.ExpressionParser;
import org.apache.commons.lang3.StringUtils;

public class ConnectedRule
implements Matcher {
    private String creditorId;
    private ExpressionMatcher left;
    private Operator operator;
    private ExpressionMatcher right;

    public ConnectedRule(Rule ruleDefinition, ExpressionParser.ExpressionContext ctx) {
        this.creditorId = ruleDefinition.getCreditorId();
        this.left = new ExpressionMatcher(ctx.expression(0), ruleDefinition);
        this.operator = Operator.fromKey(ctx.operator().getText());
        this.right = new ExpressionMatcher(ctx.expression(1), ruleDefinition);
    }

    public boolean match(WrappedBooking input) {
        if (this.creditorId != null && StringUtils.equalsIgnoreCase((CharSequence)this.creditorId, (CharSequence)input.getCreditorId())) {
            return true;
        }
        return this.operator.link(input, this.left, this.right);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.creditorId != null) {
            sb = sb.append("CREDITOR-ID: ").append(this.creditorId);
        }
        return sb.append("(").append(this.left).append(") ").append((Object)this.operator).append(" (").append(this.right).append(")").toString();
    }
}

