/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.smartanalytics.rule;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

enum Compare {
    EQUALS("="){

        @Override
        public boolean evaluate(String left, String right) {
            return StringUtils.equals((CharSequence)left, (CharSequence)right);
        }
    }
    ,
    LIKE("LIKE"){

        @Override
        public boolean evaluate(String pattern, String wert) {
            return Compare.pattern(pattern).matcher(wert).matches();
        }
    }
    ,
    NOT_LIKE("NOT LIKE"){

        @Override
        public boolean evaluate(String pattern, String wert) {
            return !Compare.pattern(pattern).matcher(wert).matches();
        }
    }
    ,
    LOWER_THAN("<"){

        @Override
        public boolean evaluate(String left, String right) {
            try {
                return new BigDecimal(left).compareTo(new BigDecimal(right)) < 0;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }
    ,
    GREATER_THAN(">"){

        @Override
        public boolean evaluate(String left, String right) {
            try {
                return new BigDecimal(left).compareTo(new BigDecimal(right)) > 0;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }
    ,
    LOWER_THAN_OR_EQUAL_TO("<="){

        @Override
        public boolean evaluate(String left, String right) {
            try {
                return new BigDecimal(left).compareTo(new BigDecimal(right)) <= 0;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }
    ,
    GREATER_THAN_OR_EQUAL_TO(">="){

        @Override
        public boolean evaluate(String left, String right) {
            try {
                return new BigDecimal(left).compareTo(new BigDecimal(right)) >= 0;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    };

    private static final Map<String, Compare> KEY_MAP;
    private String key;

    private Compare(String key) {
        this.key = key;
    }

    public static Compare fromKey(String key) {
        return KEY_MAP.get(key);
    }

    private static Pattern pattern(String pattern) {
        String regex = "^" + StringUtils.replace((String)pattern, (String)"%", (String)"(.*)") + "$";
        return Pattern.compile(regex);
    }

    public String getKey() {
        return this.key;
    }

    public abstract boolean evaluate(String var1, String var2);

    static {
        KEY_MAP = new HashMap<String, Compare>();
        for (Compare compare : Compare.values()) {
            KEY_MAP.put(compare.getKey(), compare);
        }
    }
}

