/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.smartanalytics.rule;

import de.adorsys.smartanalytics.api.Matcher;
import de.adorsys.smartanalytics.api.WrappedBooking;
import de.adorsys.smartanalytics.rule.Attribute;
import de.adorsys.smartanalytics.rule.Compare;
import de.adorsys.smartanalytics.rule.syntax.ExpressionParser;
import org.apache.commons.lang3.StringUtils;

public class Statement
implements Matcher {
    private static final String QUOTE_CHAR = "'";
    private Attribute attribute;
    private Compare compare;
    private String value;
    private String creditorId;

    public Statement(String creditorId, ExpressionParser.StatementContext ctx) {
        this.creditorId = creditorId;
        this.attribute = Attribute.valueOf(Statement.removeQuotes(ctx.attribute().getText()));
        this.compare = Compare.fromKey(ctx.comparator().getText());
        this.value = Statement.removeQuotes(ctx.value().getText()).toUpperCase();
    }

    private static String removeQuotes(String s) {
        return StringUtils.removeEnd((String)StringUtils.removeStart((String)s, (String)QUOTE_CHAR), (String)QUOTE_CHAR);
    }

    public boolean match(WrappedBooking input) {
        if (this.creditorId != null && StringUtils.equalsIgnoreCase((CharSequence)this.creditorId, (CharSequence)input.getCreditorId())) {
            return true;
        }
        return this.compare.evaluate(this.value, this.attribute.value(input));
    }

    public String toString() {
        if (this.creditorId == null) {
            return String.format("%s %s '%s'", new Object[]{this.attribute, this.compare, this.value});
        }
        return String.format("CREDITOR-ID %s OR %s %s '%s'", new Object[]{this.creditorId, this.attribute, this.compare, this.value});
    }
}

