/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.smartanalytics.rule;

import de.adorsys.smartanalytics.api.WrappedBooking;
import de.adorsys.smartanalytics.matcher.ExpressionMatcher;
import java.util.HashMap;
import java.util.Map;

enum Operator {
    AND("AND"){

        @Override
        public boolean link(WrappedBooking input, ExpressionMatcher left, ExpressionMatcher right) {
            return left.match(input) && right.match(input);
        }
    }
    ,
    OR("OR"){

        @Override
        public boolean link(WrappedBooking input, ExpressionMatcher left, ExpressionMatcher right) {
            return left.match(input) || right.match(input);
        }
    };

    private static final Map<String, Operator> KEY_MAP;
    private String key;

    private Operator(String key) {
        this.key = key;
    }

    public static Operator fromKey(String key) {
        return KEY_MAP.get(key);
    }

    public String getKey() {
        return this.key;
    }

    public abstract boolean link(WrappedBooking var1, ExpressionMatcher var2, ExpressionMatcher var3);

    static {
        KEY_MAP = new HashMap<String, Operator>();
        for (Operator operator : Operator.values()) {
            KEY_MAP.put(operator.getKey(), operator);
        }
    }
}

