/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.smartanalytics.matcher;

import de.adorsys.smartanalytics.api.Matcher;
import de.adorsys.smartanalytics.api.Rule;
import de.adorsys.smartanalytics.api.WrappedBooking;
import de.adorsys.smartanalytics.matcher.BookingMatcher;
import de.adorsys.smartanalytics.matcher.CreditorIdMatcher;
import de.adorsys.smartanalytics.rule.ConnectedRule;
import de.adorsys.smartanalytics.rule.Statement;
import de.adorsys.smartanalytics.rule.syntax.ExpressionParser;

public class ExpressionMatcher
implements BookingMatcher {
    private Rule rule;
    private boolean isNegative;
    private Matcher matcher;

    public ExpressionMatcher(ExpressionParser.ExpressionContext ctx, Rule definition) {
        this.rule = definition;
        if (ctx == null) {
            this.matcher = new CreditorIdMatcher(definition.getCreditorId());
        } else if (ctx.expression().size() == 1) {
            this.isNegative = this.isChildNegative(ctx);
            this.matcher = new ExpressionMatcher(ctx.expression(0), definition);
        } else if (ctx.expression().size() == 2 && ctx.operator() != null) {
            this.matcher = new ConnectedRule(definition, ctx);
        } else if (ctx.statement() != null) {
            this.matcher = new Statement(definition.getCreditorId(), ctx.statement());
        }
        if (this.matcher == null) {
            throw new IllegalArgumentException("Invalid matcher expression: " + definition.getExpression());
        }
    }

    public boolean match(WrappedBooking input) {
        return this.isNegative ^ this.matcher.match(input);
    }

    @Override
    public String getId() {
        return this.rule.getRuleId();
    }

    @Override
    public void extend(WrappedBooking wrappedBooking) {
        wrappedBooking.applyRule(this.rule);
    }

    @Override
    public boolean isFinal() {
        return this.rule.isStop();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isNegative) {
            sb.append("NOT (");
        }
        sb.append(this.matcher.toString());
        if (this.isNegative) {
            sb.append(")");
        }
        return sb.toString();
    }

    private boolean isChildNegative(ExpressionParser.ExpressionContext ctx) {
        return ctx.getChild(0) != null && "NOT".equals(ctx.getChild(0).getText());
    }
}

