/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.smartanalytics;

import de.adorsys.smartanalytics.api.Booking;
import de.adorsys.smartanalytics.api.WrappedBooking;
import de.adorsys.smartanalytics.modifier.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CategorizationService {
    private static final Logger log = LoggerFactory.getLogger(CategorizationService.class);

    public List<WrappedBooking> categorize(List<Booking> bookings, List<Modifier> modifierList) {
        log.info("categorize {} bookings", (Object)bookings.size());
        ArrayList<WrappedBooking> result = new ArrayList<WrappedBooking>();
        for (Booking booking : bookings) {
            WrappedBooking wrappedBooking = new WrappedBooking(booking);
            for (Modifier modifier : modifierList) {
                modifier.modify(wrappedBooking);
            }
            result.add(wrappedBooking);
        }
        return result;
    }
}

