/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.smartanalytics.utils;

import de.adorsys.smartanalytics.api.Matcher;
import de.adorsys.smartanalytics.api.Rule;
import de.adorsys.smartanalytics.matcher.ExpressionMatcher;
import de.adorsys.smartanalytics.matcher.SimilarityMatcher;
import de.adorsys.smartanalytics.rule.syntax.ExpressionLexer;
import de.adorsys.smartanalytics.rule.syntax.ExpressionParser;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ConsoleErrorListener;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RulesFactory {
    private static final Logger log = LoggerFactory.getLogger(RulesFactory.class);

    public static Matcher createExpressionMatcher(String expression) {
        Rule rule = new Rule();
        rule.setExpression(expression);
        return RulesFactory.createExpressionMatcher(rule);
    }

    public static SimilarityMatcher createSimilarityMatcher(Rule rule) {
        return new SimilarityMatcher(rule);
    }

    public static ExpressionMatcher createExpressionMatcher(Rule rule) {
        ExpressionParser.ExpressionContext ruleContext = null;
        if (StringUtils.isNotBlank((CharSequence)rule.getExpression())) {
            try {
                CodePointCharStream input = CharStreams.fromReader((Reader)new StringReader(rule.getExpression()));
                ExpressionLexer lexer = new ExpressionLexer((CharStream)input);
                lexer.removeErrorListeners();
                lexer.addErrorListener((ANTLRErrorListener)new ConsoleErrorListener((CharStream)input){
                    final /* synthetic */ CharStream val$input;
                    {
                        this.val$input = charStream;
                    }

                    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                        log.warn("line " + line + ":" + charPositionInLine + " " + msg);
                        log.warn(this.val$input.toString());
                    }
                });
                ExpressionParser parser = new ExpressionParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
                ruleContext = parser.expression();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return new ExpressionMatcher(ruleContext, rule);
    }
}

