/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.smartanalytics.matcher;

import de.adorsys.smartanalytics.api.Rule;
import de.adorsys.smartanalytics.api.WrappedBooking;
import de.adorsys.smartanalytics.matcher.BookingMatcher;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.similarity.JaroWinklerDistance;

public class SimilarityMatcher
implements BookingMatcher {
    private static final JaroWinklerDistance JARO_WINKLER = new JaroWinklerDistance();
    private Rule rule;

    public SimilarityMatcher(Rule definition) {
        this.rule = definition;
    }

    public boolean match(WrappedBooking wrappedBooking) {
        switch (this.rule.getSimilarityMatchType()) {
            case IBAN: {
                return StringUtils.equalsIgnoreCase((CharSequence)this.rule.getExpression(), (CharSequence)wrappedBooking.getBankConnection());
            }
            case REFERENCE_NAME: {
                if (wrappedBooking.getReferenceName() != null) {
                    return JARO_WINKLER.apply((CharSequence)this.rule.getExpression(), (CharSequence)wrappedBooking.getReferenceName().toLowerCase()) >= 0.75;
                }
                return false;
            }
            case PURPOSE: {
                return JARO_WINKLER.apply((CharSequence)this.rule.getExpression(), (CharSequence)SimilarityMatcher.normalize(wrappedBooking.getPurpose())) >= 0.75;
            }
        }
        throw new IllegalArgumentException("missing match type");
    }

    @Override
    public String getId() {
        return this.rule.getRuleId();
    }

    @Override
    public void extend(WrappedBooking wrappedBooking) {
        wrappedBooking.applyRule(this.rule);
    }

    @Override
    public boolean isFinal() {
        return this.rule.isStop();
    }

    private static String normalize(String s) {
        if (s == null) {
            return null;
        }
        return s.toLowerCase().replace("\u00fc", "ue").replace("\u00f6", "oe").replace("\u00e4", "ae").replace("\u00df", "ss").replaceAll("[^a-z ]+", " ");
    }
}

