/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.smartanalytics.api;

import de.adorsys.smartanalytics.api.WrappedBooking;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.stream.Collectors;

public enum Cycle {
    WEEKLY(6, 8, 14L, 3),
    MONTHLY(27, 35, 40L, 5),
    TWO_MONTHLY(54, 70, 78L, 5),
    QUARTERLY(85, 100, 110L, 7),
    HALF_YEARLY(170, 195, 200L, 7),
    YEARLY(355, 375, 380L, 10);

    private final int minDays;
    private final int maxDays;
    private final long maxDiff;
    private final int tolerance;

    private Cycle(int minDays, int maxDays, long maxDiff, int tolerance) {
        this.minDays = minDays;
        this.maxDays = maxDays;
        this.maxDiff = maxDiff;
        this.tolerance = tolerance;
    }

    public boolean isValid(LocalDate bookingDate, LocalDate referenceDate) {
        long dateDiff = ChronoUnit.DAYS.between(bookingDate, referenceDate);
        return dateDiff < this.maxDiff;
    }

    public boolean isReferenceDateBeforeBookingDateWithTolerance(LocalDate bookingDate, LocalDate referenceDate) {
        LocalDate dateWithTolerance = bookingDate.plusDays(this.tolerance);
        return referenceDate.isBefore(dateWithTolerance);
    }

    public boolean isOneValidWithinTolerance(LocalDate bookingDate, List<LocalDate> bookingDates) {
        return bookingDates.stream().anyMatch(datum -> this.isValidWithinTolerance(bookingDate, (LocalDate)datum));
    }

    public boolean isValidWithinTolerance(LocalDate nextBookingDate, LocalDate lastBookingDate) {
        return lastBookingDate.isAfter(nextBookingDate.minusDays((long)this.tolerance + 1L)) && !lastBookingDate.isAfter(nextBookingDate.plusDays(this.tolerance));
    }

    public boolean isBookingGroupValid(List<WrappedBooking> bookings, LocalDate bookingDate) {
        List withinTolerance = bookings.stream().filter(booking -> booking.getExecutionDate().isAfter(bookingDate.minusDays(this.maxDiff))).filter(booking -> !booking.getExecutionDate().isAfter(bookingDate)).collect(Collectors.toList());
        return !withinTolerance.isEmpty();
    }

    public LocalDate nextBookingDate(LocalDate bookingDate) {
        if (this == WEEKLY) {
            return bookingDate.plusWeeks(1L);
        }
        if (this == MONTHLY) {
            return bookingDate.plusMonths(1L);
        }
        if (this == TWO_MONTHLY) {
            return bookingDate.plusMonths(2L);
        }
        if (this == QUARTERLY) {
            return bookingDate.plusMonths(3L);
        }
        if (this == HALF_YEARLY) {
            return bookingDate.plusMonths(6L);
        }
        return bookingDate.plusYears(1L);
    }

    public int getMinDays() {
        return this.minDays;
    }

    public int getMaxDays() {
        return this.maxDays;
    }
}

