/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.smartanalytics.api;

import de.adorsys.smartanalytics.api.BookingPeriod;
import de.adorsys.smartanalytics.api.Cycle;
import de.adorsys.smartanalytics.api.WrappedBooking;
import de.adorsys.smartanalytics.api.config.Group;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

public class BookingGroup {
    private String firstKey;
    private String secondKey;
    private Group.Type groupType;
    private String name;
    private boolean salaryWage;
    protected Cycle cycle;
    private BigDecimal amount;
    private List<BookingPeriod> bookingPeriods;
    private String mainCategory;
    private String subCategory;
    private String specification;
    private String email;
    private String hotline;
    private String homepage;
    private String logo;
    private boolean cancelled;
    private boolean contract;
    private String mandatreference;
    private String otherAccount;

    public BookingGroup(String firstKey, String secondKey, String name, Group.Type groupType) {
        this.firstKey = firstKey;
        this.secondKey = secondKey;
        this.name = name;
        this.groupType = groupType;
    }

    public boolean isEffective(LocalDate referenceDate, List<WrappedBooking> bookings) {
        return this.cycle != null && this.cycle.isValid(bookings.get(bookings.size() - 1).getExecutionDate(), referenceDate);
    }

    public boolean isIncome() {
        return this.groupType == Group.Type.RECURRENT_INCOME || this.groupType == Group.Type.OTHER_INCOME;
    }

    public boolean isSalaryWageGroup() {
        return this.groupType == Group.Type.RECURRENT_INCOME && this.subCategory != null && (this.subCategory.equals("EINKOMMEN") || this.subCategory.equals("RENTE"));
    }

    public boolean isRecurrent() {
        return this.groupType != Group.Type.CUSTOM && this.groupType != Group.Type.OTHER_INCOME && this.groupType != Group.Type.OTHER_EXPENSES;
    }

    public String getFirstKey() {
        return this.firstKey;
    }

    public String getSecondKey() {
        return this.secondKey;
    }

    public Group.Type getGroupType() {
        return this.groupType;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSalaryWage() {
        return this.salaryWage;
    }

    public Cycle getCycle() {
        return this.cycle;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public List<BookingPeriod> getBookingPeriods() {
        return this.bookingPeriods;
    }

    public String getMainCategory() {
        return this.mainCategory;
    }

    public String getSubCategory() {
        return this.subCategory;
    }

    public String getSpecification() {
        return this.specification;
    }

    public String getEmail() {
        return this.email;
    }

    public String getHotline() {
        return this.hotline;
    }

    public String getHomepage() {
        return this.homepage;
    }

    public String getLogo() {
        return this.logo;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean isContract() {
        return this.contract;
    }

    public String getMandatreference() {
        return this.mandatreference;
    }

    public String getOtherAccount() {
        return this.otherAccount;
    }

    public void setFirstKey(String firstKey) {
        this.firstKey = firstKey;
    }

    public void setSecondKey(String secondKey) {
        this.secondKey = secondKey;
    }

    public void setGroupType(Group.Type groupType) {
        this.groupType = groupType;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSalaryWage(boolean salaryWage) {
        this.salaryWage = salaryWage;
    }

    public void setCycle(Cycle cycle) {
        this.cycle = cycle;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public void setBookingPeriods(List<BookingPeriod> bookingPeriods) {
        this.bookingPeriods = bookingPeriods;
    }

    public void setMainCategory(String mainCategory) {
        this.mainCategory = mainCategory;
    }

    public void setSubCategory(String subCategory) {
        this.subCategory = subCategory;
    }

    public void setSpecification(String specification) {
        this.specification = specification;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setHotline(String hotline) {
        this.hotline = hotline;
    }

    public void setHomepage(String homepage) {
        this.homepage = homepage;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public void setContract(boolean contract) {
        this.contract = contract;
    }

    public void setMandatreference(String mandatreference) {
        this.mandatreference = mandatreference;
    }

    public void setOtherAccount(String otherAccount) {
        this.otherAccount = otherAccount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BookingGroup)) {
            return false;
        }
        BookingGroup other = (BookingGroup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$firstKey = this.getFirstKey();
        String other$firstKey = other.getFirstKey();
        if (this$firstKey == null ? other$firstKey != null : !this$firstKey.equals(other$firstKey)) {
            return false;
        }
        String this$secondKey = this.getSecondKey();
        String other$secondKey = other.getSecondKey();
        if (this$secondKey == null ? other$secondKey != null : !this$secondKey.equals(other$secondKey)) {
            return false;
        }
        Group.Type this$groupType = this.getGroupType();
        Group.Type other$groupType = other.getGroupType();
        if (this$groupType == null ? other$groupType != null : !((Object)((Object)this$groupType)).equals((Object)other$groupType)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        if (this.isSalaryWage() != other.isSalaryWage()) {
            return false;
        }
        Cycle this$cycle = this.getCycle();
        Cycle other$cycle = other.getCycle();
        if (this$cycle == null ? other$cycle != null : !((Object)((Object)this$cycle)).equals((Object)other$cycle)) {
            return false;
        }
        BigDecimal this$amount = this.getAmount();
        BigDecimal other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        List<BookingPeriod> this$bookingPeriods = this.getBookingPeriods();
        List<BookingPeriod> other$bookingPeriods = other.getBookingPeriods();
        if (this$bookingPeriods == null ? other$bookingPeriods != null : !((Object)this$bookingPeriods).equals(other$bookingPeriods)) {
            return false;
        }
        String this$mainCategory = this.getMainCategory();
        String other$mainCategory = other.getMainCategory();
        if (this$mainCategory == null ? other$mainCategory != null : !this$mainCategory.equals(other$mainCategory)) {
            return false;
        }
        String this$subCategory = this.getSubCategory();
        String other$subCategory = other.getSubCategory();
        if (this$subCategory == null ? other$subCategory != null : !this$subCategory.equals(other$subCategory)) {
            return false;
        }
        String this$specification = this.getSpecification();
        String other$specification = other.getSpecification();
        if (this$specification == null ? other$specification != null : !this$specification.equals(other$specification)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$hotline = this.getHotline();
        String other$hotline = other.getHotline();
        if (this$hotline == null ? other$hotline != null : !this$hotline.equals(other$hotline)) {
            return false;
        }
        String this$homepage = this.getHomepage();
        String other$homepage = other.getHomepage();
        if (this$homepage == null ? other$homepage != null : !this$homepage.equals(other$homepage)) {
            return false;
        }
        String this$logo = this.getLogo();
        String other$logo = other.getLogo();
        if (this$logo == null ? other$logo != null : !this$logo.equals(other$logo)) {
            return false;
        }
        if (this.isCancelled() != other.isCancelled()) {
            return false;
        }
        if (this.isContract() != other.isContract()) {
            return false;
        }
        String this$mandatreference = this.getMandatreference();
        String other$mandatreference = other.getMandatreference();
        if (this$mandatreference == null ? other$mandatreference != null : !this$mandatreference.equals(other$mandatreference)) {
            return false;
        }
        String this$otherAccount = this.getOtherAccount();
        String other$otherAccount = other.getOtherAccount();
        return !(this$otherAccount == null ? other$otherAccount != null : !this$otherAccount.equals(other$otherAccount));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BookingGroup;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $firstKey = this.getFirstKey();
        result = result * 59 + ($firstKey == null ? 43 : $firstKey.hashCode());
        String $secondKey = this.getSecondKey();
        result = result * 59 + ($secondKey == null ? 43 : $secondKey.hashCode());
        Group.Type $groupType = this.getGroupType();
        result = result * 59 + ($groupType == null ? 43 : ((Object)((Object)$groupType)).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        result = result * 59 + (this.isSalaryWage() ? 79 : 97);
        Cycle $cycle = this.getCycle();
        result = result * 59 + ($cycle == null ? 43 : ((Object)((Object)$cycle)).hashCode());
        BigDecimal $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        List<BookingPeriod> $bookingPeriods = this.getBookingPeriods();
        result = result * 59 + ($bookingPeriods == null ? 43 : ((Object)$bookingPeriods).hashCode());
        String $mainCategory = this.getMainCategory();
        result = result * 59 + ($mainCategory == null ? 43 : $mainCategory.hashCode());
        String $subCategory = this.getSubCategory();
        result = result * 59 + ($subCategory == null ? 43 : $subCategory.hashCode());
        String $specification = this.getSpecification();
        result = result * 59 + ($specification == null ? 43 : $specification.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $hotline = this.getHotline();
        result = result * 59 + ($hotline == null ? 43 : $hotline.hashCode());
        String $homepage = this.getHomepage();
        result = result * 59 + ($homepage == null ? 43 : $homepage.hashCode());
        String $logo = this.getLogo();
        result = result * 59 + ($logo == null ? 43 : $logo.hashCode());
        result = result * 59 + (this.isCancelled() ? 79 : 97);
        result = result * 59 + (this.isContract() ? 79 : 97);
        String $mandatreference = this.getMandatreference();
        result = result * 59 + ($mandatreference == null ? 43 : $mandatreference.hashCode());
        String $otherAccount = this.getOtherAccount();
        result = result * 59 + ($otherAccount == null ? 43 : $otherAccount.hashCode());
        return result;
    }

    public String toString() {
        return "BookingGroup(firstKey=" + this.getFirstKey() + ", secondKey=" + this.getSecondKey() + ", groupType=" + (Object)((Object)this.getGroupType()) + ", name=" + this.getName() + ", salaryWage=" + this.isSalaryWage() + ", cycle=" + (Object)((Object)this.getCycle()) + ", amount=" + this.getAmount() + ", bookingPeriods=" + this.getBookingPeriods() + ", mainCategory=" + this.getMainCategory() + ", subCategory=" + this.getSubCategory() + ", specification=" + this.getSpecification() + ", email=" + this.getEmail() + ", hotline=" + this.getHotline() + ", homepage=" + this.getHomepage() + ", logo=" + this.getLogo() + ", cancelled=" + this.isCancelled() + ", contract=" + this.isContract() + ", mandatreference=" + this.getMandatreference() + ", otherAccount=" + this.getOtherAccount() + ")";
    }

    public BookingGroup() {
    }
}

