/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.smartanalytics.api;

import de.adorsys.smartanalytics.api.Booking;
import de.adorsys.smartanalytics.api.Cycle;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class WrappedBooking
implements Cloneable {
    protected Booking booking;
    private String mainCategory;
    private String subCategory;
    private String specification;
    private String receiver;
    private String logo;
    private String homepage;
    private String hotline;
    private String email;
    private LocalDate nextBookingDate;
    private boolean variable;
    private Cycle cycle;
    private Set<String> usedRules = new HashSet<String>();

    public WrappedBooking(Booking booking) {
        this.booking = booking;
    }

    public String getReferenceName() {
        if (this.booking == null) {
            return null;
        }
        return this.booking.getReferenceName();
    }

    public String getCreditorId() {
        if (this.booking == null) {
            return null;
        }
        return this.booking.getCreditorId();
    }

    public String getPurpose() {
        if (this.booking == null) {
            return null;
        }
        return this.booking.getPurpose();
    }

    public String getIban() {
        if (this.booking == null) {
            return null;
        }
        return this.booking.getIban();
    }

    public String getAccountNumber() {
        if (this.booking == null) {
            return null;
        }
        return this.booking.getAccountNumber();
    }

    public String getBankCode() {
        if (this.booking == null) {
            return null;
        }
        return this.booking.getBankCode();
    }

    public BigDecimal getAmount() {
        if (this.booking == null) {
            return null;
        }
        return this.booking.getAmount();
    }

    public void setAmount(BigDecimal amount) {
        this.booking.setAmount(amount);
    }

    public LocalDate getExecutionDate() {
        if (this.booking == null) {
            return null;
        }
        return this.booking.getExecutionDate();
    }

    public String getMandateReference() {
        if (this.booking == null) {
            return null;
        }
        return this.booking.getMandateReference();
    }

    public Booking.BookingType getType() {
        if (this.booking == null) {
            return null;
        }
        return this.booking.getType();
    }

    public Set<String> getRuleIds() {
        if (this.usedRules.size() == 0) {
            return null;
        }
        return this.usedRules;
    }

    public Booking getBooking() {
        return this.booking;
    }

    public String getBankConnection() {
        if (this.booking == null) {
            return null;
        }
        if (this.getIban() != null) {
            return this.getIban();
        }
        if (StringUtils.isNotBlank((CharSequence)this.getBankCode()) && StringUtils.isNotBlank((CharSequence)this.getAccountNumber())) {
            return this.getBankCode() + this.getAccountNumber();
        }
        return this.getReferenceName();
    }

    public void putUsedRule(String id) {
        this.usedRules.add(id);
    }

    public WrappedBooking clone() {
        try {
            WrappedBooking extension = (WrappedBooking)super.clone();
            extension.booking = this.booking.clone();
            return extension;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public String getMainCategory() {
        return this.mainCategory;
    }

    public String getSubCategory() {
        return this.subCategory;
    }

    public String getSpecification() {
        return this.specification;
    }

    public String getReceiver() {
        return this.receiver;
    }

    public String getLogo() {
        return this.logo;
    }

    public String getHomepage() {
        return this.homepage;
    }

    public String getHotline() {
        return this.hotline;
    }

    public String getEmail() {
        return this.email;
    }

    public LocalDate getNextBookingDate() {
        return this.nextBookingDate;
    }

    public boolean isVariable() {
        return this.variable;
    }

    public Cycle getCycle() {
        return this.cycle;
    }

    public Set<String> getUsedRules() {
        return this.usedRules;
    }

    public void setBooking(Booking booking) {
        this.booking = booking;
    }

    public void setMainCategory(String mainCategory) {
        this.mainCategory = mainCategory;
    }

    public void setSubCategory(String subCategory) {
        this.subCategory = subCategory;
    }

    public void setSpecification(String specification) {
        this.specification = specification;
    }

    public void setReceiver(String receiver) {
        this.receiver = receiver;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public void setHomepage(String homepage) {
        this.homepage = homepage;
    }

    public void setHotline(String hotline) {
        this.hotline = hotline;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setNextBookingDate(LocalDate nextBookingDate) {
        this.nextBookingDate = nextBookingDate;
    }

    public void setVariable(boolean variable) {
        this.variable = variable;
    }

    public void setCycle(Cycle cycle) {
        this.cycle = cycle;
    }

    public void setUsedRules(Set<String> usedRules) {
        this.usedRules = usedRules;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WrappedBooking)) {
            return false;
        }
        WrappedBooking other = (WrappedBooking)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Booking this$booking = this.getBooking();
        Booking other$booking = other.getBooking();
        if (this$booking == null ? other$booking != null : !((Object)this$booking).equals(other$booking)) {
            return false;
        }
        String this$mainCategory = this.getMainCategory();
        String other$mainCategory = other.getMainCategory();
        if (this$mainCategory == null ? other$mainCategory != null : !this$mainCategory.equals(other$mainCategory)) {
            return false;
        }
        String this$subCategory = this.getSubCategory();
        String other$subCategory = other.getSubCategory();
        if (this$subCategory == null ? other$subCategory != null : !this$subCategory.equals(other$subCategory)) {
            return false;
        }
        String this$specification = this.getSpecification();
        String other$specification = other.getSpecification();
        if (this$specification == null ? other$specification != null : !this$specification.equals(other$specification)) {
            return false;
        }
        String this$receiver = this.getReceiver();
        String other$receiver = other.getReceiver();
        if (this$receiver == null ? other$receiver != null : !this$receiver.equals(other$receiver)) {
            return false;
        }
        String this$logo = this.getLogo();
        String other$logo = other.getLogo();
        if (this$logo == null ? other$logo != null : !this$logo.equals(other$logo)) {
            return false;
        }
        String this$homepage = this.getHomepage();
        String other$homepage = other.getHomepage();
        if (this$homepage == null ? other$homepage != null : !this$homepage.equals(other$homepage)) {
            return false;
        }
        String this$hotline = this.getHotline();
        String other$hotline = other.getHotline();
        if (this$hotline == null ? other$hotline != null : !this$hotline.equals(other$hotline)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        LocalDate this$nextBookingDate = this.getNextBookingDate();
        LocalDate other$nextBookingDate = other.getNextBookingDate();
        if (this$nextBookingDate == null ? other$nextBookingDate != null : !((Object)this$nextBookingDate).equals(other$nextBookingDate)) {
            return false;
        }
        if (this.isVariable() != other.isVariable()) {
            return false;
        }
        Cycle this$cycle = this.getCycle();
        Cycle other$cycle = other.getCycle();
        if (this$cycle == null ? other$cycle != null : !((Object)((Object)this$cycle)).equals((Object)other$cycle)) {
            return false;
        }
        Set<String> this$usedRules = this.getUsedRules();
        Set<String> other$usedRules = other.getUsedRules();
        return !(this$usedRules == null ? other$usedRules != null : !((Object)this$usedRules).equals(other$usedRules));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WrappedBooking;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Booking $booking = this.getBooking();
        result = result * 59 + ($booking == null ? 43 : ((Object)$booking).hashCode());
        String $mainCategory = this.getMainCategory();
        result = result * 59 + ($mainCategory == null ? 43 : $mainCategory.hashCode());
        String $subCategory = this.getSubCategory();
        result = result * 59 + ($subCategory == null ? 43 : $subCategory.hashCode());
        String $specification = this.getSpecification();
        result = result * 59 + ($specification == null ? 43 : $specification.hashCode());
        String $receiver = this.getReceiver();
        result = result * 59 + ($receiver == null ? 43 : $receiver.hashCode());
        String $logo = this.getLogo();
        result = result * 59 + ($logo == null ? 43 : $logo.hashCode());
        String $homepage = this.getHomepage();
        result = result * 59 + ($homepage == null ? 43 : $homepage.hashCode());
        String $hotline = this.getHotline();
        result = result * 59 + ($hotline == null ? 43 : $hotline.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        LocalDate $nextBookingDate = this.getNextBookingDate();
        result = result * 59 + ($nextBookingDate == null ? 43 : ((Object)$nextBookingDate).hashCode());
        result = result * 59 + (this.isVariable() ? 79 : 97);
        Cycle $cycle = this.getCycle();
        result = result * 59 + ($cycle == null ? 43 : ((Object)((Object)$cycle)).hashCode());
        Set<String> $usedRules = this.getUsedRules();
        result = result * 59 + ($usedRules == null ? 43 : ((Object)$usedRules).hashCode());
        return result;
    }

    public String toString() {
        return "WrappedBooking(booking=" + this.getBooking() + ", mainCategory=" + this.getMainCategory() + ", subCategory=" + this.getSubCategory() + ", specification=" + this.getSpecification() + ", receiver=" + this.getReceiver() + ", logo=" + this.getLogo() + ", homepage=" + this.getHomepage() + ", hotline=" + this.getHotline() + ", email=" + this.getEmail() + ", nextBookingDate=" + this.getNextBookingDate() + ", variable=" + this.isVariable() + ", cycle=" + (Object)((Object)this.getCycle()) + ", usedRules=" + this.getUsedRules() + ")";
    }

    public WrappedBooking(Booking booking, String mainCategory, String subCategory, String specification, String receiver, String logo, String homepage, String hotline, String email, LocalDate nextBookingDate, boolean variable, Cycle cycle, Set<String> usedRules) {
        this.booking = booking;
        this.mainCategory = mainCategory;
        this.subCategory = subCategory;
        this.specification = specification;
        this.receiver = receiver;
        this.logo = logo;
        this.homepage = homepage;
        this.hotline = hotline;
        this.email = email;
        this.nextBookingDate = nextBookingDate;
        this.variable = variable;
        this.cycle = cycle;
        this.usedRules = usedRules;
    }

    public WrappedBooking() {
    }
}

