/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.smartanalytics.api;

import de.adorsys.smartanalytics.api.Booking;
import de.adorsys.smartanalytics.api.Cycle;
import de.adorsys.smartanalytics.api.WrappedBooking;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

public class BookingGroup {
    private String firstKey;
    private String secondKey;
    protected Cycle cycle;
    private boolean variable = false;
    private BigDecimal amount;
    private List<LocalDate> bookingDates;
    private LocalDate nextExecutionDate;
    private Booking.BookingType bookingType;
    private String mainCategory;
    private String subCategory;
    private String specification;
    private String email;
    private String hotline;
    private String homepage;
    private String logo;
    private boolean contract;
    private String mandatreference;
    private String provider;

    public BookingGroup(String firstKey, String secondKey, Booking.BookingType bookingType) {
        this.firstKey = firstKey;
        this.secondKey = secondKey;
        this.bookingType = bookingType;
    }

    public boolean isEffective(LocalDate referenceDate, List<WrappedBooking> bookings) {
        return this.cycle != null && this.cycle.isValid(bookings.get(bookings.size() - 1).getExecutionDate(), referenceDate);
    }

    public String getFirstKey() {
        return this.firstKey;
    }

    public String getSecondKey() {
        return this.secondKey;
    }

    public Cycle getCycle() {
        return this.cycle;
    }

    public boolean isVariable() {
        return this.variable;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public List<LocalDate> getBookingDates() {
        return this.bookingDates;
    }

    public LocalDate getNextExecutionDate() {
        return this.nextExecutionDate;
    }

    public Booking.BookingType getBookingType() {
        return this.bookingType;
    }

    public String getMainCategory() {
        return this.mainCategory;
    }

    public String getSubCategory() {
        return this.subCategory;
    }

    public String getSpecification() {
        return this.specification;
    }

    public String getEmail() {
        return this.email;
    }

    public String getHotline() {
        return this.hotline;
    }

    public String getHomepage() {
        return this.homepage;
    }

    public String getLogo() {
        return this.logo;
    }

    public boolean isContract() {
        return this.contract;
    }

    public String getMandatreference() {
        return this.mandatreference;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setFirstKey(String firstKey) {
        this.firstKey = firstKey;
    }

    public void setSecondKey(String secondKey) {
        this.secondKey = secondKey;
    }

    public void setCycle(Cycle cycle) {
        this.cycle = cycle;
    }

    public void setVariable(boolean variable) {
        this.variable = variable;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public void setBookingDates(List<LocalDate> bookingDates) {
        this.bookingDates = bookingDates;
    }

    public void setNextExecutionDate(LocalDate nextExecutionDate) {
        this.nextExecutionDate = nextExecutionDate;
    }

    public void setBookingType(Booking.BookingType bookingType) {
        this.bookingType = bookingType;
    }

    public void setMainCategory(String mainCategory) {
        this.mainCategory = mainCategory;
    }

    public void setSubCategory(String subCategory) {
        this.subCategory = subCategory;
    }

    public void setSpecification(String specification) {
        this.specification = specification;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setHotline(String hotline) {
        this.hotline = hotline;
    }

    public void setHomepage(String homepage) {
        this.homepage = homepage;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public void setContract(boolean contract) {
        this.contract = contract;
    }

    public void setMandatreference(String mandatreference) {
        this.mandatreference = mandatreference;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BookingGroup)) {
            return false;
        }
        BookingGroup other = (BookingGroup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$firstKey = this.getFirstKey();
        String other$firstKey = other.getFirstKey();
        if (this$firstKey == null ? other$firstKey != null : !this$firstKey.equals(other$firstKey)) {
            return false;
        }
        String this$secondKey = this.getSecondKey();
        String other$secondKey = other.getSecondKey();
        if (this$secondKey == null ? other$secondKey != null : !this$secondKey.equals(other$secondKey)) {
            return false;
        }
        Cycle this$cycle = this.getCycle();
        Cycle other$cycle = other.getCycle();
        if (this$cycle == null ? other$cycle != null : !((Object)((Object)this$cycle)).equals((Object)other$cycle)) {
            return false;
        }
        if (this.isVariable() != other.isVariable()) {
            return false;
        }
        BigDecimal this$amount = this.getAmount();
        BigDecimal other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        List<LocalDate> this$bookingDates = this.getBookingDates();
        List<LocalDate> other$bookingDates = other.getBookingDates();
        if (this$bookingDates == null ? other$bookingDates != null : !((Object)this$bookingDates).equals(other$bookingDates)) {
            return false;
        }
        LocalDate this$nextExecutionDate = this.getNextExecutionDate();
        LocalDate other$nextExecutionDate = other.getNextExecutionDate();
        if (this$nextExecutionDate == null ? other$nextExecutionDate != null : !((Object)this$nextExecutionDate).equals(other$nextExecutionDate)) {
            return false;
        }
        Booking.BookingType this$bookingType = this.getBookingType();
        Booking.BookingType other$bookingType = other.getBookingType();
        if (this$bookingType == null ? other$bookingType != null : !((Object)((Object)this$bookingType)).equals((Object)other$bookingType)) {
            return false;
        }
        String this$mainCategory = this.getMainCategory();
        String other$mainCategory = other.getMainCategory();
        if (this$mainCategory == null ? other$mainCategory != null : !this$mainCategory.equals(other$mainCategory)) {
            return false;
        }
        String this$subCategory = this.getSubCategory();
        String other$subCategory = other.getSubCategory();
        if (this$subCategory == null ? other$subCategory != null : !this$subCategory.equals(other$subCategory)) {
            return false;
        }
        String this$specification = this.getSpecification();
        String other$specification = other.getSpecification();
        if (this$specification == null ? other$specification != null : !this$specification.equals(other$specification)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$hotline = this.getHotline();
        String other$hotline = other.getHotline();
        if (this$hotline == null ? other$hotline != null : !this$hotline.equals(other$hotline)) {
            return false;
        }
        String this$homepage = this.getHomepage();
        String other$homepage = other.getHomepage();
        if (this$homepage == null ? other$homepage != null : !this$homepage.equals(other$homepage)) {
            return false;
        }
        String this$logo = this.getLogo();
        String other$logo = other.getLogo();
        if (this$logo == null ? other$logo != null : !this$logo.equals(other$logo)) {
            return false;
        }
        if (this.isContract() != other.isContract()) {
            return false;
        }
        String this$mandatreference = this.getMandatreference();
        String other$mandatreference = other.getMandatreference();
        if (this$mandatreference == null ? other$mandatreference != null : !this$mandatreference.equals(other$mandatreference)) {
            return false;
        }
        String this$provider = this.getProvider();
        String other$provider = other.getProvider();
        return !(this$provider == null ? other$provider != null : !this$provider.equals(other$provider));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BookingGroup;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $firstKey = this.getFirstKey();
        result = result * 59 + ($firstKey == null ? 43 : $firstKey.hashCode());
        String $secondKey = this.getSecondKey();
        result = result * 59 + ($secondKey == null ? 43 : $secondKey.hashCode());
        Cycle $cycle = this.getCycle();
        result = result * 59 + ($cycle == null ? 43 : ((Object)((Object)$cycle)).hashCode());
        result = result * 59 + (this.isVariable() ? 79 : 97);
        BigDecimal $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        List<LocalDate> $bookingDates = this.getBookingDates();
        result = result * 59 + ($bookingDates == null ? 43 : ((Object)$bookingDates).hashCode());
        LocalDate $nextExecutionDate = this.getNextExecutionDate();
        result = result * 59 + ($nextExecutionDate == null ? 43 : ((Object)$nextExecutionDate).hashCode());
        Booking.BookingType $bookingType = this.getBookingType();
        result = result * 59 + ($bookingType == null ? 43 : ((Object)((Object)$bookingType)).hashCode());
        String $mainCategory = this.getMainCategory();
        result = result * 59 + ($mainCategory == null ? 43 : $mainCategory.hashCode());
        String $subCategory = this.getSubCategory();
        result = result * 59 + ($subCategory == null ? 43 : $subCategory.hashCode());
        String $specification = this.getSpecification();
        result = result * 59 + ($specification == null ? 43 : $specification.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $hotline = this.getHotline();
        result = result * 59 + ($hotline == null ? 43 : $hotline.hashCode());
        String $homepage = this.getHomepage();
        result = result * 59 + ($homepage == null ? 43 : $homepage.hashCode());
        String $logo = this.getLogo();
        result = result * 59 + ($logo == null ? 43 : $logo.hashCode());
        result = result * 59 + (this.isContract() ? 79 : 97);
        String $mandatreference = this.getMandatreference();
        result = result * 59 + ($mandatreference == null ? 43 : $mandatreference.hashCode());
        String $provider = this.getProvider();
        result = result * 59 + ($provider == null ? 43 : $provider.hashCode());
        return result;
    }

    public String toString() {
        return "BookingGroup(firstKey=" + this.getFirstKey() + ", secondKey=" + this.getSecondKey() + ", cycle=" + (Object)((Object)this.getCycle()) + ", variable=" + this.isVariable() + ", amount=" + this.getAmount() + ", bookingDates=" + this.getBookingDates() + ", nextExecutionDate=" + this.getNextExecutionDate() + ", bookingType=" + (Object)((Object)this.getBookingType()) + ", mainCategory=" + this.getMainCategory() + ", subCategory=" + this.getSubCategory() + ", specification=" + this.getSpecification() + ", email=" + this.getEmail() + ", hotline=" + this.getHotline() + ", homepage=" + this.getHomepage() + ", logo=" + this.getLogo() + ", contract=" + this.isContract() + ", mandatreference=" + this.getMandatreference() + ", provider=" + this.getProvider() + ")";
    }

    public BookingGroup() {
    }
}

