/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sdjwt.vp;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.util.Base64URL;
import de.adorsys.sdjwt.IssuerSignedJWT;
import de.adorsys.sdjwt.IssuerSignedJwtVerificationOpts;
import de.adorsys.sdjwt.SdJwtUtils;
import de.adorsys.sdjwt.SdJwtVerificationContext;
import de.adorsys.sdjwt.exception.SdJwtVerificationException;
import de.adorsys.sdjwt.vp.KeyBindingJWT;
import de.adorsys.sdjwt.vp.KeyBindingJwtVerificationOpts;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class SdJwtVP {
    private final String sdJwtVpString;
    private final IssuerSignedJWT issuerSignedJWT;
    private final Map<String, ArrayNode> claims;
    private final Map<String, String> disclosures;
    private final Map<String, String> recursiveDigests;
    private final List<String> ghostDigests;
    private final String hashAlgorithm;
    private final Optional<KeyBindingJWT> keyBindingJWT;

    public Map<String, ArrayNode> getClaims() {
        return this.claims;
    }

    public IssuerSignedJWT getIssuerSignedJWT() {
        return this.issuerSignedJWT;
    }

    public Map<String, String> getDisclosures() {
        return this.disclosures;
    }

    public Collection<String> getDisclosuresString() {
        return this.disclosures.values();
    }

    public Map<String, String> getRecursiveDigests() {
        return this.recursiveDigests;
    }

    public Collection<String> getGhostDigests() {
        return this.ghostDigests;
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public Optional<KeyBindingJWT> getKeyBindingJWT() {
        return this.keyBindingJWT;
    }

    private SdJwtVP(String sdJwtVpString, String hashAlgorithm, IssuerSignedJWT issuerSignedJWT, Map<String, ArrayNode> claims, Map<String, String> disclosures, Map<String, String> recursiveDigests, List<String> ghostDigests, Optional<KeyBindingJWT> keyBindingJWT) {
        this.sdJwtVpString = sdJwtVpString;
        this.hashAlgorithm = hashAlgorithm;
        this.issuerSignedJWT = issuerSignedJWT;
        this.claims = Collections.unmodifiableMap(claims);
        this.disclosures = Collections.unmodifiableMap(disclosures);
        this.recursiveDigests = Collections.unmodifiableMap(recursiveDigests);
        this.ghostDigests = Collections.unmodifiableList(ghostDigests);
        this.keyBindingJWT = keyBindingJWT;
    }

    public static SdJwtVP of(String sdJwtString) {
        String[] split;
        int disclosureStart = sdJwtString.indexOf("~");
        int disclosureEnd = sdJwtString.lastIndexOf("~");
        if (disclosureStart == -1) {
            throw new IllegalArgumentException("SD-JWT is malformed, expected to end with ~");
        }
        String issuerSignedJWTString = sdJwtString.substring(0, disclosureStart);
        String disclosuresString = "";
        if (disclosureEnd > disclosureStart) {
            disclosuresString = sdJwtString.substring(disclosureStart + 1, disclosureEnd);
        }
        IssuerSignedJWT issuerSignedJWT = IssuerSignedJWT.fromJws(issuerSignedJWTString);
        ObjectNode issuerPayload = (ObjectNode)issuerSignedJWT.getPayload();
        JsonNode jsonNode = issuerPayload.get("_sd_alg");
        JsonNodeType nodeType = jsonNode.getNodeType();
        String hashAlgorithm = jsonNode.asText();
        HashMap<String, ArrayNode> claims = new HashMap<String, ArrayNode>();
        HashMap<String, String> disclosures = new HashMap<String, String>();
        for (String disclosure : split = disclosuresString.split("~")) {
            String disclosureDigest2 = SdJwtUtils.hashAndBase64EncodeNoPad(disclosure.getBytes(), hashAlgorithm);
            if (disclosures.containsKey(disclosureDigest2)) {
                throw new IllegalArgumentException("Duplicate disclosure digest");
            }
            disclosures.put(disclosureDigest2, disclosure);
            try {
                ArrayNode disclosureData = (ArrayNode)SdJwtUtils.mapper.readTree(new Base64URL(disclosure).decode());
                claims.put(disclosureDigest2, disclosureData);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Invalid disclosure data");
            }
        }
        Set allDigests = claims.keySet();
        HashMap<String, String> recursiveDigests = new HashMap<String, String>();
        ArrayList<String> ghostDigests = new ArrayList<String>();
        allDigests.stream().forEach(disclosureDigest -> {
            JsonNode node = SdJwtVP.findNode((JsonNode)issuerPayload, disclosureDigest);
            node = SdJwtVP.processDisclosureDigest(node, disclosureDigest, claims, recursiveDigests, ghostDigests);
        });
        Optional<KeyBindingJWT> keyBindingJWT = Optional.empty();
        if (sdJwtString.length() > disclosureEnd + 1) {
            String keyBindingJWTString = sdJwtString.substring(disclosureEnd + 1);
            keyBindingJWT = Optional.of(KeyBindingJWT.of(keyBindingJWTString));
        }
        String sdJWtVPString = sdJwtString.substring(0, disclosureEnd + 1);
        return new SdJwtVP(sdJWtVPString, hashAlgorithm, issuerSignedJWT, claims, disclosures, recursiveDigests, ghostDigests, keyBindingJWT);
    }

    private static JsonNode processDisclosureDigest(JsonNode node, String disclosureDigest, Map<String, ArrayNode> claims, Map<String, String> recursiveDigests, List<String> ghostDigests) {
        if (node == null) {
            Set<Map.Entry<String, ArrayNode>> entrySet = claims.entrySet();
            for (Map.Entry<String, ArrayNode> entry : entrySet) {
                if (entry.getKey().equals(disclosureDigest) || (node = SdJwtVP.findNode((JsonNode)entry.getValue(), disclosureDigest)) == null) continue;
                recursiveDigests.put(disclosureDigest, entry.getKey());
                break;
            }
        }
        if (node == null) {
            ghostDigests.add(disclosureDigest);
        }
        return node;
    }

    public JsonNode getCnfClaim() {
        return this.issuerSignedJWT.getCnfClaim().orElse(null);
    }

    public String present(List<String> disclosureDigests, JsonNode keyBindingClaims, JWSSigner holdSignatureSignerContext, String keyId, JWSAlgorithm jwsAlgorithm, String jwsType) {
        StringBuilder sb = new StringBuilder();
        if (disclosureDigests == null || disclosureDigests.isEmpty()) {
            sb.append(this.sdJwtVpString);
        } else {
            sb.append(this.issuerSignedJWT.toJws());
            sb.append("~");
            for (String disclosureDigest : disclosureDigests) {
                sb.append(this.disclosures.get(disclosureDigest));
                sb.append("~");
            }
        }
        String unboundPresentation = sb.toString();
        if (keyBindingClaims == null || holdSignatureSignerContext == null) {
            return unboundPresentation;
        }
        String sd_hash = SdJwtUtils.hashAndBase64EncodeNoPad(unboundPresentation.getBytes(), this.getHashAlgorithm());
        keyBindingClaims = ((ObjectNode)keyBindingClaims).put("sd_hash", sd_hash);
        KeyBindingJWT keyBindingJWT = KeyBindingJWT.from(keyBindingClaims, holdSignatureSignerContext, keyId, jwsAlgorithm, jwsType);
        sb.append(keyBindingJWT.toJws());
        return sb.toString();
    }

    public void verify(IssuerSignedJwtVerificationOpts issuerSignedJwtVerificationOpts, KeyBindingJwtVerificationOpts keyBindingJwtVerificationOpts) throws SdJwtVerificationException {
        new SdJwtVerificationContext(this.sdJwtVpString, this.issuerSignedJWT, this.disclosures, this.keyBindingJWT.orElse(null)).verifyPresentation(issuerSignedJwtVerificationOpts, keyBindingJwtVerificationOpts);
    }

    private static JsonNode findNode(JsonNode node, String value) {
        if (node == null) {
            return null;
        }
        if (node.isValueNode()) {
            if (node.asText().equals(value)) {
                return node;
            }
            return null;
        }
        if (node.isArray() || node.isObject()) {
            for (JsonNode child : node) {
                JsonNode found = SdJwtVP.findNode(child, value);
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }

    public String toString() {
        return this.sdJwtVpString;
    }

    public String verbose() {
        StringBuilder sb = new StringBuilder();
        sb.append("Issuer Signed JWT: ");
        sb.append(this.issuerSignedJWT.getPayload());
        sb.append("\n");
        this.disclosures.forEach((digest, disclosure) -> {
            sb.append("\n");
            sb.append("Digest: ");
            sb.append((String)digest);
            sb.append("\n");
            sb.append("Disclosure: ");
            sb.append((String)disclosure);
            sb.append("\n");
            sb.append("Content: ");
            sb.append(this.claims.get(digest));
            sb.append("\n");
        });
        sb.append("\n");
        sb.append("Recursive Digests: ");
        sb.append(this.recursiveDigests);
        sb.append("\n");
        sb.append("\n");
        sb.append("Ghost Digests: ");
        sb.append(this.ghostDigests);
        sb.append("\n");
        sb.append("\n");
        if (this.keyBindingJWT.isPresent()) {
            sb.append("Key Binding JWT: ");
            sb.append("\n");
            sb.append(this.keyBindingJWT.get().getPayload().toString());
            sb.append("\n");
        }
        return sb.toString();
    }
}

