/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sdjwt;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.nimbusds.jose.util.Base64URL;
import de.adorsys.sdjwt.exception.SdJwtVerificationException;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Optional;

public class SdJwtUtils {
    public static final ObjectMapper mapper = new ObjectMapper();
    private static final SecureRandom RANDOM = new SecureRandom();
    static ArraySpacedPrettyPrinter arraySpacedPrettyPrinter = new ArraySpacedPrettyPrinter();
    public static boolean arrayEltSpaced = true;

    public static String encodeNoPad(byte[] bytes) {
        return Base64URL.encode((byte[])bytes).toString();
    }

    public static byte[] decodeNoPad(String encoded) {
        return Base64.getUrlDecoder().decode(encoded);
    }

    public static String hashAndBase64EncodeNoPad(byte[] disclosureBytes, String hashAlg) {
        return SdJwtUtils.encodeNoPad(SdJwtUtils.hash(disclosureBytes, hashAlg));
    }

    public static String requireNonEmpty(String str, String message) {
        return Optional.ofNullable(str).filter(s -> !s.isEmpty()).orElseThrow(() -> new IllegalArgumentException(message));
    }

    public static String randomSalt() {
        return SdJwtUtils.encodeNoPad(SdJwtUtils.randomBytes(16));
    }

    public static byte[] randomBytes(int size) {
        byte[] bytes = new byte[size];
        RANDOM.nextBytes(bytes);
        return bytes;
    }

    public static String printJsonArray(Object[] array) throws JsonProcessingException {
        if (arrayEltSpaced) {
            return SdJwtUtils.arraySpacedPrettyPrinter.writer.writeValueAsString((Object)array);
        }
        return mapper.writeValueAsString((Object)array);
    }

    public static byte[] hash(byte[] bytes, String hashAlg) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance(hashAlg);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        return digest.digest(bytes);
    }

    public static ArrayNode decodeDisclosureString(String disclosure) throws SdJwtVerificationException {
        JsonNode jsonNode;
        String decoded = new String(SdJwtUtils.decodeNoPad(disclosure));
        try {
            jsonNode = mapper.readTree(decoded);
        }
        catch (JsonProcessingException e) {
            throw new SdJwtVerificationException("Disclosure is not a valid JSON", e);
        }
        if (!jsonNode.isArray()) {
            throw new SdJwtVerificationException("Disclosure is not a JSON array");
        }
        return (ArrayNode)jsonNode;
    }

    public static long readTimeClaim(JsonNode payload, String claimName) throws SdJwtVerificationException {
        JsonNode claim = payload.get(claimName);
        if (claim == null || !claim.isNumber()) {
            throw new SdJwtVerificationException("Missing or invalid '" + claimName + "' claim");
        }
        return claim.asLong();
    }

    public static String readClaim(JsonNode payload, String claimName) throws SdJwtVerificationException {
        JsonNode claim = payload.get(claimName);
        if (claim == null) {
            throw new SdJwtVerificationException("Missing '" + claimName + "' claim");
        }
        return claim.textValue();
    }

    public static JsonNode deepClone(JsonNode node) {
        try {
            byte[] serializedNode = mapper.writeValueAsBytes((Object)node);
            return mapper.readTree(serializedNode);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static class ArraySpacedPrettyPrinter
    extends MinimalPrettyPrinter {
        final ObjectMapper prettyPrinObjectMapper = new ObjectMapper();
        final ObjectWriter writer;

        public ArraySpacedPrettyPrinter() {
            this.prettyPrinObjectMapper.setDefaultPrettyPrinter((PrettyPrinter)this);
            this.writer = this.prettyPrinObjectMapper.writer((PrettyPrinter)this);
        }

        public void writeArrayValueSeparator(JsonGenerator jg) throws IOException {
            jg.writeRaw(',');
            jg.writeRaw(' ');
        }

        public void writeObjectEntrySeparator(JsonGenerator jg) throws IOException {
            jg.writeRaw(',');
            jg.writeRaw(' ');
        }

        public void writeObjectFieldValueSeparator(JsonGenerator jg) throws IOException {
            jg.writeRaw(':');
            jg.writeRaw(' ');
        }
    }
}

