/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sdjwt;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.nimbusds.jose.JWSSigner;
import de.adorsys.sdjwt.ArrayDisclosure;
import de.adorsys.sdjwt.DecoyClaim;
import de.adorsys.sdjwt.DisclosureSpec;
import de.adorsys.sdjwt.IssuerSignedJWT;
import de.adorsys.sdjwt.IssuerSignedJwtVerificationOpts;
import de.adorsys.sdjwt.SdJwtClaim;
import de.adorsys.sdjwt.SdJwtClaimName;
import de.adorsys.sdjwt.SdJwtSalt;
import de.adorsys.sdjwt.SdJwtVerificationContext;
import de.adorsys.sdjwt.UndisclosedClaim;
import de.adorsys.sdjwt.VisibleSdJwtClaim;
import de.adorsys.sdjwt.exception.SdJwtVerificationException;
import de.adorsys.sdjwt.vp.KeyBindingJWT;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class SdJwt {
    public static final String DELIMITER = "~";
    private final IssuerSignedJWT issuerSignedJWT;
    private final List<SdJwtClaim> claims;
    private final List<String> disclosures = new ArrayList<String>();
    private Optional<String> sdJwtString = Optional.empty();

    private SdJwt(DisclosureSpec disclosureSpec, JsonNode claimSet, List<SdJwt> nesteSdJwts, Optional<KeyBindingJWT> keyBindingJWT, JWSSigner signer, String keyId, String hashAlgorithm, String jwsType) {
        this.claims = new ArrayList<SdJwtClaim>();
        claimSet.fields().forEachRemaining(entry -> this.claims.add(this.createClaim((String)entry.getKey(), (JsonNode)entry.getValue(), disclosureSpec)));
        this.issuerSignedJWT = IssuerSignedJWT.builder().withClaims(this.claims).withDecoyClaims(this.createdDecoyClaims(disclosureSpec)).withNestedDisclosures(!nesteSdJwts.isEmpty()).withSigner(signer).withKeyId(keyId).withHashAlg(hashAlgorithm).withJwsType(jwsType).build();
        nesteSdJwts.forEach(nestedJwt -> this.disclosures.addAll(nestedJwt.getDisclosures()));
        this.disclosures.addAll(SdJwt.getDisclosureStrings(this.claims));
    }

    private List<DecoyClaim> createdDecoyClaims(DisclosureSpec disclosureSpec) {
        return disclosureSpec.getDecoyClaims().stream().map(disclosureData -> DecoyClaim.builder().withSalt(disclosureData.getSalt()).build()).collect(Collectors.toList());
    }

    public JsonNode asNestedPayload() {
        JsonNode nestedPayload = this.issuerSignedJWT.getPayload();
        ((ObjectNode)nestedPayload).remove("_sd_alg");
        return nestedPayload;
    }

    public String toSdJwtString() {
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(this.issuerSignedJWT.toJws());
        parts.addAll(this.disclosures);
        parts.add("");
        return String.join((CharSequence)DELIMITER, parts);
    }

    private static List<String> getDisclosureStrings(List<SdJwtClaim> claims) {
        ArrayList disclosureStrings = new ArrayList();
        claims.stream().map(SdJwtClaim::getDisclosureStrings).forEach(disclosureStrings::addAll);
        return Collections.unmodifiableList(disclosureStrings);
    }

    public String toString() {
        return this.sdJwtString.orElseGet(() -> {
            String sdString = this.toSdJwtString();
            this.sdJwtString = Optional.of(sdString);
            return sdString;
        });
    }

    private SdJwtClaim createClaim(String claimName, JsonNode claimValue, DisclosureSpec disclosureSpec) {
        DisclosureSpec.DisclosureData disclosureData = disclosureSpec.getUndisclosedClaim(SdJwtClaimName.of(claimName));
        if (disclosureData != null) {
            return this.createUndisclosedClaim(claimName, claimValue, disclosureData.getSalt());
        }
        return this.createArrayOrVisibleClaim(claimName, claimValue, disclosureSpec);
    }

    private SdJwtClaim createUndisclosedClaim(String claimName, JsonNode claimValue, SdJwtSalt salt) {
        return UndisclosedClaim.builder().withClaimName(claimName).withClaimValue(claimValue).withSalt(salt).build();
    }

    private SdJwtClaim createArrayOrVisibleClaim(String claimName, JsonNode claimValue, DisclosureSpec disclosureSpec) {
        SdJwtClaimName sdJwtClaimName = SdJwtClaimName.of(claimName);
        Map<Integer, DisclosureSpec.DisclosureData> undisclosedArrayElts = disclosureSpec.getUndisclosedArrayElts(sdJwtClaimName);
        Map<Integer, DisclosureSpec.DisclosureData> decoyArrayElts = disclosureSpec.getDecoyArrayElts(sdJwtClaimName);
        if (undisclosedArrayElts != null || decoyArrayElts != null) {
            return this.createArrayDisclosure(claimName, claimValue, undisclosedArrayElts, decoyArrayElts);
        }
        return VisibleSdJwtClaim.builder().withClaimName(claimName).withClaimValue(claimValue).build();
    }

    private SdJwtClaim createArrayDisclosure(String claimName, JsonNode claimValue, Map<Integer, DisclosureSpec.DisclosureData> undisclosedArrayElts, Map<Integer, DisclosureSpec.DisclosureData> decoyArrayElts) {
        ArrayNode arrayNode = this.validateArrayNode(claimName, claimValue);
        ArrayDisclosure.Builder arrayDisclosureBuilder = ArrayDisclosure.builder().withClaimName(claimName);
        if (undisclosedArrayElts != null) {
            IntStream.range(0, arrayNode.size()).forEach(i -> this.processArrayElement(arrayDisclosureBuilder, arrayNode.get(i), (DisclosureSpec.DisclosureData)undisclosedArrayElts.get(i)));
        }
        if (decoyArrayElts != null) {
            decoyArrayElts.forEach((key, value) -> arrayDisclosureBuilder.withDecoyElt((Integer)key, value.getSalt()));
        }
        return arrayDisclosureBuilder.build();
    }

    private ArrayNode validateArrayNode(String claimName, JsonNode claimValue) {
        return Optional.of(claimValue).filter(v -> v.getNodeType() == JsonNodeType.ARRAY).map(v -> (ArrayNode)v).orElseThrow(() -> new IllegalArgumentException("Expected array for claim with name: " + claimName));
    }

    private void processArrayElement(ArrayDisclosure.Builder builder, JsonNode elementValue, DisclosureSpec.DisclosureData disclosureData) {
        if (disclosureData != null) {
            builder.withUndisclosedElement(disclosureData.getSalt(), elementValue);
        } else {
            builder.withVisibleElement(elementValue);
        }
    }

    public IssuerSignedJWT getIssuerSignedJWT() {
        return this.issuerSignedJWT;
    }

    public List<String> getDisclosures() {
        return this.disclosures;
    }

    public void verify(IssuerSignedJwtVerificationOpts verificationOpts) throws SdJwtVerificationException {
        new SdJwtVerificationContext(this.issuerSignedJWT, this.disclosures).verifyIssuance(verificationOpts);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private DisclosureSpec disclosureSpec;
        private JsonNode claimSet;
        private Optional<KeyBindingJWT> keyBindingJWT = Optional.empty();
        private JWSSigner signer;
        private final List<SdJwt> nestedSdJwts = new ArrayList<SdJwt>();
        private String hashAlgorithm;
        private String jwsType;
        private String keyId;

        public Builder withDisclosureSpec(DisclosureSpec disclosureSpec) {
            this.disclosureSpec = disclosureSpec;
            return this;
        }

        public Builder withClaimSet(JsonNode claimSet) {
            this.claimSet = claimSet;
            return this;
        }

        public Builder withKeyBindingJWT(KeyBindingJWT keyBindingJWT) {
            this.keyBindingJWT = Optional.of(keyBindingJWT);
            return this;
        }

        public Builder withSigner(JWSSigner signer) {
            this.signer = signer;
            return this;
        }

        public Builder withKeyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public Builder withNestedSdJwt(SdJwt nestedSdJwt) {
            this.nestedSdJwts.add(nestedSdJwt);
            return this;
        }

        public Builder withHashAlgorithm(String hashAlgorithm) {
            this.hashAlgorithm = hashAlgorithm;
            return this;
        }

        public Builder withJwsType(String jwsType) {
            this.jwsType = jwsType;
            return this;
        }

        public SdJwt build() {
            return new SdJwt(this.disclosureSpec, this.claimSet, this.nestedSdJwts, this.keyBindingJWT, this.signer, this.keyId, this.hashAlgorithm, this.jwsType);
        }
    }
}

