/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sdjwt;

import com.fasterxml.jackson.core.JsonProcessingException;
import de.adorsys.sdjwt.SdJwtSalt;
import de.adorsys.sdjwt.SdJwtUtils;
import java.util.Objects;

public abstract class Disclosable {
    private final SdJwtSalt salt;

    abstract Object[] toArray();

    protected Disclosable(SdJwtSalt salt) {
        this.salt = Objects.requireNonNull(salt, "Disclosure always requires a salt must not be null");
    }

    public SdJwtSalt getSalt() {
        return this.salt;
    }

    public String getSaltAsString() {
        return this.salt.toString();
    }

    public String toJson() {
        try {
            return SdJwtUtils.printJsonArray(this.toArray());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public String getDisclosureString() {
        String json = this.toJson();
        return SdJwtUtils.encodeNoPad(json.getBytes());
    }

    public String getDisclosureDigest(String hashAlg) {
        return SdJwtUtils.encodeNoPad(SdJwtUtils.hash(this.getDisclosureString().getBytes(), hashAlg));
    }

    public String toString() {
        return this.getDisclosureString();
    }
}

