/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sdjwt;

import com.fasterxml.jackson.databind.JsonNode;
import de.adorsys.sdjwt.Disclosable;
import de.adorsys.sdjwt.SdJwtArrayElement;
import de.adorsys.sdjwt.SdJwtSalt;
import de.adorsys.sdjwt.SdJwtUtils;
import java.util.Objects;

public class UndisclosedArrayElement
extends Disclosable
implements SdJwtArrayElement {
    public static final String SD_CLAIM_NAME = "...";
    private final JsonNode arrayElement;

    private UndisclosedArrayElement(SdJwtSalt salt, JsonNode arrayElement) {
        super(salt);
        this.arrayElement = arrayElement;
    }

    @Override
    public JsonNode getVisibleValue(String hashAlg) {
        return SdJwtUtils.mapper.createObjectNode().put(SD_CLAIM_NAME, this.getDisclosureDigest(hashAlg));
    }

    @Override
    Object[] toArray() {
        return new Object[]{this.getSaltAsString(), this.arrayElement};
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private SdJwtSalt salt;
        private JsonNode arrayElement;

        public Builder withSalt(SdJwtSalt salt) {
            this.salt = salt;
            return this;
        }

        public Builder withArrayElement(JsonNode arrayElement) {
            this.arrayElement = arrayElement;
            return this;
        }

        public UndisclosedArrayElement build() {
            this.arrayElement = Objects.requireNonNull(this.arrayElement, "arrayElement must not be null");
            this.salt = this.salt == null ? new SdJwtSalt(SdJwtUtils.randomSalt()) : this.salt;
            return new UndisclosedArrayElement(this.salt, this.arrayElement);
        }
    }
}

