/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sdjwt;

import com.fasterxml.jackson.databind.JsonNode;
import de.adorsys.sdjwt.AbstractSdJwtClaim;
import de.adorsys.sdjwt.SdJwtClaimName;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class VisibleSdJwtClaim
extends AbstractSdJwtClaim {
    private final JsonNode claimValue;

    public VisibleSdJwtClaim(SdJwtClaimName claimName, JsonNode claimValue) {
        super(claimName);
        this.claimValue = claimValue;
    }

    @Override
    public JsonNode getVisibleClaimValue(String hashAlgo) {
        return this.claimValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public List<String> getDisclosureStrings() {
        return Collections.emptyList();
    }

    public static class Builder {
        private SdJwtClaimName claimName;
        private JsonNode claimValue;

        public Builder withClaimName(String claimName) {
            this.claimName = new SdJwtClaimName(claimName);
            return this;
        }

        public Builder withClaimValue(JsonNode claimValue) {
            this.claimValue = claimValue;
            return this;
        }

        public VisibleSdJwtClaim build() {
            this.claimName = Objects.requireNonNull(this.claimName, "claimName must not be null");
            this.claimValue = Objects.requireNonNull(this.claimValue, "claimValue must not be null");
            return new VisibleSdJwtClaim(this.claimName, this.claimValue);
        }
    }
}

