/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sdjwt;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.nimbusds.jose.util.Base64URL;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Optional;

public class SdJwtUtils {
    public static final ObjectMapper mapper = new ObjectMapper();
    private static final SecureRandom RANDOM = new SecureRandom();
    static ArraySpacedPrettyPrinter arraySpacedPrettyPrinter = new ArraySpacedPrettyPrinter();
    public static boolean arrayEltSpaced = true;

    public static String encodeNoPad(byte[] bytes) {
        return Base64URL.encode((byte[])bytes).toString();
    }

    public static String hashAndBase64EncodeNoPad(byte[] disclosureBytes, String hashAlg) {
        return SdJwtUtils.encodeNoPad(SdJwtUtils.hash(disclosureBytes, hashAlg));
    }

    public static String requireNonEmpty(String str, String message) {
        return Optional.ofNullable(str).filter(s -> !s.isEmpty()).orElseThrow(() -> new IllegalArgumentException(message));
    }

    public static String randomSalt() {
        return SdJwtUtils.encodeNoPad(SdJwtUtils.randomBytes(16));
    }

    public static byte[] randomBytes(int size) {
        byte[] bytes = new byte[size];
        RANDOM.nextBytes(bytes);
        return bytes;
    }

    public static String printJsonArray(Object[] array) throws JsonProcessingException {
        if (arrayEltSpaced) {
            return SdJwtUtils.arraySpacedPrettyPrinter.writer.writeValueAsString((Object)array);
        }
        return mapper.writeValueAsString((Object)array);
    }

    public static byte[] hash(byte[] bytes, String hashAlg) {
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance(hashAlg);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        return digest.digest(bytes);
    }

    static class ArraySpacedPrettyPrinter
    extends MinimalPrettyPrinter {
        final ObjectMapper prettyPrinObjectMapper = new ObjectMapper();
        final ObjectWriter writer;

        public ArraySpacedPrettyPrinter() {
            this.prettyPrinObjectMapper.setDefaultPrettyPrinter((PrettyPrinter)this);
            this.writer = this.prettyPrinObjectMapper.writer((PrettyPrinter)this);
        }

        public void writeArrayValueSeparator(JsonGenerator jg) throws IOException {
            jg.writeRaw(',');
            jg.writeRaw(' ');
        }

        public void writeObjectEntrySeparator(JsonGenerator jg) throws IOException {
            jg.writeRaw(',');
            jg.writeRaw(' ');
        }

        public void writeObjectFieldValueSeparator(JsonGenerator jg) throws IOException {
            jg.writeRaw(':');
            jg.writeRaw(' ');
        }
    }
}

